/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.tileentity;

import com.google.common.collect.Lists;
import harmonised.pmmo.events.FurnaceHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.AirItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import wily.betterfurnaces.Config;
import wily.betterfurnaces.blocks.BlockForgeBase;
import wily.betterfurnaces.blocks.BlockIronFurnace;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.ItemUpgrade;
import wily.betterfurnaces.items.ItemUpgradeLiquidFuel;
import wily.betterfurnaces.items.ItemUpgradeOreProcessing;
import wily.betterfurnaces.tileentity.BlockForgeTileBase;
import wily.betterfurnaces.tileentity.FurnaceSettings;
import wily.betterfurnaces.tileentity.LRUCache;
import wily.betterfurnaces.tileentity.TileEntityInventory;
import wily.betterfurnaces.util.DirectionUtil;

public abstract class BlockSmeltingTileBase
extends TileEntityInventory
implements ITickableTileEntity,
IRecipeHolder,
IRecipeHelperPopulator {
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    private Random rand = new Random();
    public int show_inventory_settings;
    protected int timer;
    private int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime = this.getCookTime();
    private int recipesUsed;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    public IRecipeType<? extends AbstractCookingRecipe> recipeType;
    public FurnaceSettings furnaceSettings;
    private LRUCache<Item, Optional<AbstractCookingRecipe>> cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    private LRUCache<Item, Optional<AbstractCookingRecipe>> blasting_cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    private LRUCache<Item, Optional<AbstractCookingRecipe>> smoking_cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    public final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BlockSmeltingTileBase.this.furnaceBurnTime;
                }
                case 1: {
                    return BlockSmeltingTileBase.this.recipesUsed;
                }
                case 2: {
                    return BlockSmeltingTileBase.this.cookTime;
                }
                case 3: {
                    return BlockSmeltingTileBase.this.totalCookTime;
                }
                case 4: {
                    return BlockSmeltingTileBase.this.show_inventory_settings;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    BlockSmeltingTileBase.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    BlockSmeltingTileBase.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    BlockSmeltingTileBase.this.cookTime = value;
                    break;
                }
                case 3: {
                    BlockSmeltingTileBase.this.totalCookTime = value;
                    break;
                }
                case 4: {
                    BlockSmeltingTileBase.this.show_inventory_settings = value;
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };
    protected final FluidTank fluidTank = new FluidTank(this.LiquidCapacity(), fs -> ForgeHooks.getBurnTime((ItemStack)new ItemStack((IItemProvider)fs.getFluid().func_204524_b())) > 0){

        protected void onContentsChanged() {
            super.onContentsChanged();
            BlockSmeltingTileBase.this.func_70296_d();
            BlockSmeltingTileBase.this.field_145850_b.func_184138_a(BlockSmeltingTileBase.this.func_174877_v(), BlockSmeltingTileBase.this.field_145850_b.func_180495_p(BlockSmeltingTileBase.this.func_174877_v()), BlockSmeltingTileBase.this.func_195044_w(), 2);
        }
    };
    protected final FluidTank xpTank = new FluidTank(2000, xp -> xp.getFluid().getRegistryName().toString().equals(Config.getLiquidXPType()) && ModList.get().isLoaded(Config.getLiquidXPMod())){

        protected void onContentsChanged() {
            super.onContentsChanged();
            BlockSmeltingTileBase.this.func_70296_d();
            BlockSmeltingTileBase.this.field_145850_b.func_184138_a(BlockSmeltingTileBase.this.func_174877_v(), BlockSmeltingTileBase.this.field_145850_b.func_180495_p(BlockSmeltingTileBase.this.func_174877_v()), BlockSmeltingTileBase.this.func_195044_w(), 2);
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(this.EnergyCapacity(), 3400, 3400, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                BlockSmeltingTileBase.this.func_70296_d();
                BlockSmeltingTileBase.this.field_145850_b.func_184138_a(BlockSmeltingTileBase.this.func_174877_v(), BlockSmeltingTileBase.this.field_145850_b.func_180495_p(BlockSmeltingTileBase.this.func_174877_v()), BlockSmeltingTileBase.this.func_195044_w(), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                BlockSmeltingTileBase.this.func_70296_d();
                BlockSmeltingTileBase.this.field_145850_b.func_184138_a(BlockSmeltingTileBase.this.func_174877_v(), BlockSmeltingTileBase.this.field_145850_b.func_180495_p(BlockSmeltingTileBase.this.func_174877_v()), BlockSmeltingTileBase.this.func_195044_w(), 2);
            }
            return retval;
        }
    };
    ITag<Item> ore = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge", "ores"));
    SidedInvWrapper invHandler = new SidedInvWrapper(this, null){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return BlockSmeltingTileBase.this.IisItemValidForSlot(slot, stack);
        }
    };
    LazyOptional<? extends IItemHandler>[] invHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});

    public int FUEL() {
        return 1;
    }

    public int[] UPGRADES() {
        return new int[]{3, 4, 5};
    }

    public int FINPUT() {
        return this.INPUTS()[0];
    }

    public int LINPUT() {
        return this.INPUTS()[this.INPUTS().length - 1];
    }

    public int FOUTPUT() {
        return this.OUTPUTS()[0];
    }

    public int LOUTPUT() {
        return this.OUTPUTS()[this.OUTPUTS().length - 1];
    }

    public int[] INPUTS() {
        return new int[]{0};
    }

    public int[] OUTPUTS() {
        return new int[]{2};
    }

    public int[] FSLOTS() {
        return ArrayUtils.addAll((int[])ArrayUtils.addAll((int[])this.ISLOTS(), (int[])this.OUTPUTS()), (int[])new int[0]);
    }

    public int[] ISLOTS() {
        return ArrayUtils.addAll((int[])this.INPUTS(), (int[])new int[this.FUEL()]);
    }

    public int EnergyUse() {
        return 600;
    }

    public int LiquidCapacity() {
        return 4000;
    }

    public int EnergyCapacity() {
        return 16000;
    }

    public boolean isForge() {
        return false;
    }

    public Direction facing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    public BlockSmeltingTileBase(TileEntityType<?> tileentitytypeIn, int invsize) {
        super(tileentitytypeIn, invsize);
        this.recipeType = IRecipeType.field_222150_b;
        this.furnaceSettings = new FurnaceSettings(){

            @Override
            public void onChanged() {
                BlockSmeltingTileBase.this.func_70296_d();
            }

            @Override
            public void set(int index, int value) {
                if (BlockSmeltingTileBase.this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
                    this.read(BlockSmeltingTileBase.this.getUpgradeTypeSlotItem((ItemUpgrade)Registration.FACTORY.get()).func_196082_o());
                }
                super.set(index, value);
                if (BlockSmeltingTileBase.this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
                    this.write(BlockSmeltingTileBase.this.getUpgradeTypeSlotItem((ItemUpgrade)Registration.FACTORY.get()).func_196082_o());
                }
            }

            @Override
            public int get(int index) {
                if (BlockSmeltingTileBase.this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
                    this.read(BlockSmeltingTileBase.this.getUpgradeTypeSlotItem((ItemUpgrade)Registration.FACTORY.get()).func_196082_o());
                }
                return super.get(index);
            }
        };
    }

    private int getFromCache(LRUCache<Item, Optional<AbstractCookingRecipe>> c, Item key) {
        if (c.get(key) == null) {
            return 0;
        }
        return ((Optional)c.get(key)).orElse(null) == null ? 0 : ((AbstractCookingRecipe)((Optional)c.get(key)).orElse(null)).func_222137_e();
    }

    public boolean hasRecipe(ItemStack stack) {
        return this.grabRecipe(stack).isPresent();
    }

    private LRUCache<Item, Optional<AbstractCookingRecipe>> getCache() {
        if (this.recipeType == IRecipeType.field_222151_c) {
            return this.blasting_cache;
        }
        if (this.recipeType == IRecipeType.field_222152_d) {
            return this.smoking_cache;
        }
        return this.cache;
    }

    private Optional<AbstractCookingRecipe> grabRecipe() {
        Item item = this.func_70301_a(this.FINPUT()).func_77973_b();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional recipe = (Optional)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    private Optional<AbstractCookingRecipe> grabRecipe(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional recipe = (Optional)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    public boolean isLiquid() {
        return this.hasUpgrade((Item)Registration.LIQUID.get());
    }

    public boolean hasXPTank() {
        return this.hasUpgrade((Item)Registration.XP.get());
    }

    private boolean isEnergy() {
        return this.hasUpgrade((Item)Registration.ENERGY.get()) && this.energyStorage.getEnergyStored() >= this.EnergyUse();
    }

    protected int getCookTime() {
        if (this.func_70301_a(this.FINPUT()).func_77973_b() == Items.field_190931_a) {
            return this.totalCookTime;
        }
        int speed = this.getSpeed();
        if (speed == -1) {
            return -1;
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int i = (Integer)this.getCookTimeConfig().get();
        int j = this.getFromCache(this.getCache(), this.func_70301_a(this.FINPUT()).func_77973_b());
        if (j == 0) {
            Optional<AbstractCookingRecipe> recipe = this.grabRecipe();
            j = !recipe.isPresent() ? -1 : ((AbstractCookingRecipe)recipe.orElse(null)).func_222137_e();
            this.getCache().put(this.func_70301_a(this.FINPUT()).func_77973_b(), recipe);
            if (j == -1) {
                return -1;
            }
        }
        if (j < i) {
            int k = j - (200 - i);
            return k;
        }
        return i;
    }

    public ForgeConfigSpec.IntValue getCookTimeConfig() {
        return null;
    }

    public boolean hasUpgrade(Item upg) {
        for (int slot : this.UPGRADES()) {
            if (upg != this.func_70301_a(slot).func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpgradeType(ItemUpgrade upg) {
        for (int slot : this.UPGRADES()) {
            if (!(this.func_70301_a(slot).func_77973_b() instanceof ItemUpgrade) || upg.upgradeType != ((ItemUpgrade)this.func_70301_a((int)slot).func_77973_b()).upgradeType) continue;
            return true;
        }
        return this.hasUpgrade(upg);
    }

    public ItemStack getUpgradeTypeSlotItem(ItemUpgrade upg) {
        for (int slot : this.UPGRADES()) {
            if (!(this.func_70301_a(slot).func_77973_b() instanceof ItemUpgrade) || upg.upgradeType != ((ItemUpgrade)this.func_70301_a((int)slot).func_77973_b()).upgradeType) continue;
            return this.func_70301_a(slot);
        }
        return this.func_70301_a(this.UPGRADES()[0]);
    }

    public ItemStack getUpgradeSlotItem(Item upg) {
        for (int slot : this.UPGRADES()) {
            if (upg != this.func_70301_a(slot).func_77973_b()) continue;
            return this.func_70301_a(slot);
        }
        return this.func_70301_a(this.UPGRADES()[0]);
    }

    public int correspondentOutputSlot(int input) {
        return 4 + input;
    }

    public void forceUpdateAllStates() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue() != this.isBurning()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
    }

    public void trySmelt() {
        this.smeltItem(this.irecipeSlot(this.FINPUT()).orElse(null), this.FINPUT(), this.FOUTPUT());
    }

    public Optional<AbstractCookingRecipe> irecipeSlot(int input) {
        if (!this.isForge() && input > this.FINPUT()) {
            return Optional.empty();
        }
        if (!this.func_70301_a(input).func_190926_b()) {
            return this.grabRecipe(this.func_70301_a(input));
        }
        return Optional.empty();
    }

    public boolean inputSlotsEmpty() {
        return !((ItemStack)this.inventory.get(this.FINPUT())).func_190926_b();
    }

    public boolean smeltValid() {
        return this.canSmelt(this.irecipeSlot(this.FINPUT()).orElse(null), this.FINPUT(), this.FOUTPUT());
    }

    public void func_73660_a() {
        if (this.furnaceSettings.size() <= 0) {
            this.furnaceSettings = new FurnaceSettings(){

                @Override
                public void onChanged() {
                    BlockSmeltingTileBase.this.func_70296_d();
                }
            };
        }
        boolean wasBurning = this.isBurning();
        boolean flag1 = false;
        boolean flag2 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (this.hasUpgrade((Item)Registration.COLOR.get())) {
            if (!((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockIronFurnace.COLORED)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockIronFurnace.COLORED, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockIronFurnace.COLORED, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (this.recipeType != IRecipeType.field_222150_b) {
            this.recipeType = IRecipeType.field_222150_b;
        }
        if (!this.field_145850_b.field_72995_K) {
            FluidActionResult res;
            int i;
            int mode;
            int get_cook_time = this.getCookTime();
            ++this.timer;
            if (this.totalCookTime != get_cook_time) {
                this.totalCookTime = get_cook_time;
            }
            if ((mode = this.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    i = 0;
                    for (Direction side : Direction.values()) {
                        if (this.field_145850_b.func_175651_c(this.field_174879_c.func_177971_a(side.func_176730_m()), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        this.cookTime = 0;
                        this.furnaceBurnTime = 0;
                        this.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (Direction side : Direction.values()) {
                        if (this.field_145850_b.func_175651_c(this.field_174879_c.func_177971_a(side.func_176730_m()), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        this.cookTime = 0;
                        this.furnaceBurnTime = 0;
                        this.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < Direction.values().length; ++i) {
                    this.provides[i] = this.func_195044_w().func_185893_b((IBlockReader)this.field_145850_b, this.field_174879_c, DirectionUtil.fromId(i));
                }
            } else {
                for (i = 0; i < Direction.values().length; ++i) {
                    this.provides[i] = 0;
                }
            }
            if (this.doesNeedUpdateSend()) {
                this.onUpdateSent();
            }
            if (this.hasXPTank()) {
                this.grantStoredRecipeExperience(this.field_145850_b, null);
            }
            if (!this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get()) && this.isForge() && ((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)BlockForgeBase.SHOW_ORIENTATION)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a((Property)BlockForgeBase.SHOW_ORIENTATION, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.func_70301_a(this.FUEL()).getCapability(CapabilityEnergy.ENERGY).ifPresent(E -> {
                if (this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
                    E.extractEnergy(this.energyStorage.receiveEnergy(E.getEnergyStored(), false), false);
                }
            });
            ItemStack itemstack = (ItemStack)this.inventory.get(this.FUEL());
            if (this.isLiquid() && itemstack.hasContainerItem() && (res = FluidUtil.tryEmptyContainer((ItemStack)itemstack, (IFluidHandler)this.fluidTank, (int)1000, null, (boolean)true)).isSuccess()) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187633_N, SoundCategory.PLAYERS, 0.6f, 0.8f);
                this.inventory.set(this.FUEL(), (Object)res.result);
            }
            if ((this.isBurning() || !itemstack.func_190926_b() || this.isLiquid() || this.isEnergy()) && this.inputSlotsEmpty()) {
                boolean valid = this.smeltValid();
                if (!this.isBurning() && valid) {
                    if (this.isLiquid() && this.fluidTank.getFluidAmount() >= 10) {
                        int f = BlockSmeltingTileBase.getBurnTime(new ItemStack((IItemProvider)this.fluidTank.getFluidInTank(1).getFluid().func_204524_b()));
                        this.furnaceBurnTime = f * get_cook_time / 20000;
                        if (this.hasUpgradeType((ItemUpgrade)Registration.FUEL.get())) {
                            this.furnaceBurnTime = 2 * f * get_cook_time / 20000;
                        }
                        this.recipesUsed = this.furnaceBurnTime;
                        this.fluidTank.drain(10, IFluidHandler.FluidAction.EXECUTE);
                    } else if (this.isEnergy() && this.isForge()) {
                        this.furnaceBurnTime = 200 * get_cook_time / 200;
                        if (this.hasUpgradeType((ItemUpgrade)Registration.FUEL.get())) {
                            this.furnaceBurnTime = 400 * get_cook_time / 200;
                        }
                        this.recipesUsed = this.furnaceBurnTime;
                        for (int i2 : this.INPUTS()) {
                            this.energyStorage.extractEnergy(this.EnergyUse() * this.OreProcessingMultiplier(this.func_70301_a(i2)), false);
                        }
                    } else {
                        this.furnaceBurnTime = this.hasUpgradeType((ItemUpgrade)Registration.FUEL.get()) ? 2 * BlockSmeltingTileBase.getBurnTime(itemstack) * get_cook_time / 200 : BlockSmeltingTileBase.getBurnTime(itemstack) * get_cook_time / 200;
                        this.recipesUsed = this.furnaceBurnTime;
                    }
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!(this.isLiquid() && this.fluidTank.getFluidAmount() >= 10 || this.isEnergy())) {
                            if (itemstack.hasContainerItem()) {
                                this.inventory.set(this.FUEL(), (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
                            } else if (!itemstack.func_190926_b() && BlockSmeltingTileBase.isItemFuel(itemstack)) {
                                itemstack.func_190918_g(1);
                                if (this.hasUpgrade((Item)Registration.FUEL.get())) {
                                    this.breakDurabilityItem(this.getUpgradeSlotItem((Item)Registration.FUEL.get()));
                                }
                            }
                        }
                    }
                }
                if (this.isBurning() && valid) {
                    ++this.cookTime;
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.trySmelt();
                        if (this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
                            this.autoIO();
                        }
                        flag1 = true;
                    }
                } else if (this.cookTime > 0) {
                    --this.cookTime;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (wasBurning != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
            if (this.timer % 24 == 0 && this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get()) && this.cookTime <= 0) {
                int a = 0;
                for (int i2 : this.INPUTS()) {
                    a += this.func_70301_a(i2).func_190916_E();
                }
                if (this.inputSlotsEmpty()) {
                    this.autoIO();
                    flag1 = true;
                } else if (this.FINPUT() - this.LINPUT() * 3 > a) {
                    this.autoIO();
                    flag1 = true;
                }
                if (this.func_70301_a(this.FUEL()).func_190926_b()) {
                    this.autoIO();
                    flag1 = true;
                } else if (this.func_70301_a(this.FUEL()).func_190916_E() < this.func_70301_a(this.FUEL()).func_77976_d()) {
                    this.autoIO();
                    flag1 = true;
                }
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int hex() {
        CompoundNBT nbt = this.getUpgradeSlotItem((Item)Registration.COLOR.get()).func_77978_p();
        return (nbt.func_74762_e("red") & 0xFF) << 16 | (nbt.func_74762_e("green") & 0xFF) << 8 | nbt.func_74762_e("blue") & 0xFF;
    }

    private void autoIO() {
        for (Direction dir : Direction.values()) {
            ItemStack stack;
            int i;
            IItemHandler other;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a(dir.func_176730_m()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 && this.furnaceSettings.get(dir.ordinal()) != 4 || tile == null || (other = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).map(other1 -> other1).orElse(null)) == null || other == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1) {
                if (this.furnaceSettings.get(dir.ordinal()) == 1 || this.furnaceSettings.get(dir.ordinal()) == 3) {
                    for (int input : this.INPUTS()) {
                        if (this.func_70301_a(input).func_190916_E() >= this.func_70301_a(input).func_77976_d()) continue;
                        for (i = 0; i < other.getSlots(); ++i) {
                            if (other.getStackInSlot(i).func_190926_b() || (!this.hasRecipe(stack = other.extractItem(i, other.getStackInSlot(i).func_77976_d(), true)) || !this.func_70301_a(input).func_190926_b()) && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.func_70301_a(input), (ItemStack)stack)) continue;
                            this.insertItemInternal(input, other.extractItem(i, other.getStackInSlot(i).func_77976_d() - this.func_70301_a(input).func_190916_E(), false), false);
                        }
                    }
                }
                if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                    if (this.func_70301_a(this.FUEL()).func_190916_E() >= this.func_70301_a(this.FUEL()).func_77976_d()) continue;
                    for (int i2 = 0; i2 < other.getSlots(); ++i2) {
                        ItemStack stack2;
                        if (other.getStackInSlot(i2).func_190926_b() || (!BlockSmeltingTileBase.isItemFuel(stack2 = other.extractItem(i2, other.getStackInSlot(i2).func_77976_d(), true)) || !this.func_70301_a(this.FUEL()).func_190926_b()) && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.func_70301_a(this.FUEL()), (ItemStack)stack2)) continue;
                        this.insertItemInternal(this.FUEL(), other.extractItem(i2, other.getStackInSlot(i2).func_77976_d() - this.func_70301_a(this.FUEL()).func_190916_E(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1) continue;
            if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                ItemStack stack3;
                if (this.func_70301_a(this.FUEL()).func_190926_b() || (stack3 = this.extractItemInternal(this.FUEL(), 1, true)).func_77973_b() != Items.field_151133_ar) continue;
                for (int i3 = 0; i3 < other.getSlots(); ++i3) {
                    if (!other.isItemValid(i3, stack3) || !other.getStackInSlot(i3).func_190926_b() && (!other.isItemValid(i3, stack3) || !ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i3), (ItemStack)stack3) || other.getStackInSlot(i3).func_190916_E() + stack3.func_190916_E() > other.getSlotLimit(i3))) continue;
                    other.insertItem(i3, this.extractItemInternal(this.FUEL(), stack3.func_190916_E(), false), false);
                }
            }
            for (int output : this.OUTPUTS()) {
                if (this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || this.func_70301_a(output).func_190926_b() || tile.func_195044_w().func_177230_c().getRegistryName().toString().contains("storagedrawers:")) continue;
                for (i = 0; i < other.getSlots(); ++i) {
                    stack = this.extractItemInternal(output, this.func_70301_a(output).func_77976_d() - other.getStackInSlot(i).func_190916_E(), true);
                    if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).func_190926_b() && (!other.isItemValid(i, stack) || !ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).func_190916_E() + stack.func_190916_E() > other.getSlotLimit(i))) continue;
                    other.insertItem(i, this.extractItemInternal(output, stack.func_190916_E(), false), false);
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.func_180462_a(slot, stack, null)) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.inventory.get(slot);
        int limit = stack.func_77976_d();
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.inventory.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.func_70296_d();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    private ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.func_70301_a(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.func_70299_a(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.func_70296_d();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSettingBottom() {
        return this.furnaceSettings.get(this.getIndexBottom());
    }

    public int getSettingTop() {
        return this.furnaceSettings.get(this.getIndexTop());
    }

    public int getSettingFront() {
        return this.furnaceSettings.get(this.getIndexFront());
    }

    public int getSettingBack() {
        return this.furnaceSettings.get(this.getIndexBack());
    }

    public int getSettingLeft() {
        return this.furnaceSettings.get(this.getIndexLeft());
    }

    public int getSettingRight() {
        return this.furnaceSettings.get(this.getIndexRight());
    }

    public int getIndexFront() {
        int i = this.facing().ordinal();
        return i;
    }

    public int getIndexBack() {
        int i = this.facing().func_176734_d().ordinal();
        return i;
    }

    public int getIndexLeft() {
        if (this.facing() == Direction.NORTH) {
            return Direction.EAST.ordinal();
        }
        if (this.facing() == Direction.WEST) {
            return Direction.NORTH.ordinal();
        }
        if (this.facing() == Direction.SOUTH) {
            return Direction.WEST.ordinal();
        }
        return Direction.SOUTH.ordinal();
    }

    public int getIndexRight() {
        if (this.facing() == Direction.NORTH) {
            return Direction.WEST.ordinal();
        }
        if (this.facing() == Direction.WEST) {
            return Direction.SOUTH.ordinal();
        }
        if (this.facing() == Direction.SOUTH) {
            return Direction.EAST.ordinal();
        }
        return Direction.NORTH.ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.get(6);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.get(7);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.get(8);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.get(9);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    protected boolean isOre(ItemStack input) {
        return input.func_77973_b().func_206844_a(this.ore) || input.func_77973_b().getRegistryName().toString().contains("ore");
    }

    protected int OreProcessingMultiplier(ItemStack input) {
        if (this.hasUpgradeType((ItemUpgrade)Registration.ORE_PROCESSING.get())) {
            ItemUpgradeOreProcessing oreup = (ItemUpgradeOreProcessing)this.getUpgradeTypeSlotItem((ItemUpgrade)Registration.ORE_PROCESSING.get()).func_77973_b();
            if (this.isOre(input)) {
                return oreup.getMultiplier;
            }
        } else if (input == ItemStack.field_190927_a) {
            return 0;
        }
        return 1;
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipe, int INPUT, int OUTPUT) {
        ItemStack recipeOutput;
        ItemStack input = (ItemStack)this.inventory.get(INPUT);
        if (!input.func_190926_b() && recipe != null && !(recipeOutput = recipe.func_77571_b()).func_190926_b()) {
            ItemStack output = (ItemStack)this.inventory.get(OUTPUT);
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(recipeOutput)) {
                return false;
            }
            return output.func_190916_E() + recipeOutput.func_190916_E() * this.OreProcessingMultiplier(input) <= output.func_77976_d();
        }
        return false;
    }

    private ItemStack getResult(@Nullable IRecipe<?> recipe, ItemStack input) {
        ItemStack out = recipe.func_77571_b().func_77946_l();
        out.func_190920_e(out.func_190916_E() * this.OreProcessingMultiplier(input));
        return out;
    }

    protected void smeltItem(@Nullable IRecipe<?> recipe, int INPUT, int OUTPUT) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe, INPUT, OUTPUT)) {
            ItemStack itemstack = (ItemStack)this.inventory.get(INPUT);
            ItemStack itemstack2 = (ItemStack)this.inventory.get(OUTPUT);
            if (itemstack2.func_190926_b()) {
                this.inventory.set(OUTPUT, (Object)this.getResult(recipe, itemstack));
                if (this.hasUpgrade((Item)Registration.ORE_PROCESSING.get()) && this.isOre(itemstack)) {
                    this.breakDurabilityItem(this.getUpgradeSlotItem((Item)Registration.ORE_PROCESSING.get()));
                }
            } else if (itemstack2.func_77973_b() == this.getResult(recipe, itemstack).func_77973_b()) {
                itemstack2.func_190917_f(this.getResult(recipe, itemstack).func_190916_E());
                if (this.hasUpgrade((Item)Registration.ORE_PROCESSING.get()) && this.isOre(itemstack)) {
                    this.breakDurabilityItem(this.getUpgradeSlotItem((Item)Registration.ORE_PROCESSING.get()));
                }
            }
            this.checkXP(recipe);
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            if (itemstack.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.inventory.get(this.FUEL())).func_190926_b() && ((ItemStack)this.inventory.get(this.FUEL())).func_77973_b() == Items.field_151133_ar) {
                this.inventory.set(this.FUEL(), (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            if (ModList.get().isLoaded("pmmo")) {
                FurnaceHandler.handleSmelted((ItemStack)itemstack, (ItemStack)itemstack2, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)0);
                if (this.recipeType == IRecipeType.field_222152_d) {
                    FurnaceHandler.handleSmelted((ItemStack)itemstack, (ItemStack)itemstack2, (World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)1);
                }
            }
            itemstack.func_190918_g(1);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)this.inventory);
        this.furnaceBurnTime = tag.func_74762_e("BurnTime");
        this.cookTime = tag.func_74762_e("CookTime");
        this.totalCookTime = tag.func_74762_e("CookTimeTotal");
        this.timer = 0;
        this.recipesUsed = BlockSmeltingTileBase.getBurnTime((ItemStack)this.inventory.get(1));
        if (tag.func_74781_a("fluidTank") != null) {
            CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.readNBT((Object)this.fluidTank, null, tag.func_74781_a("fluidTank"));
        }
        if (tag.func_74781_a("xpTank") != null) {
            CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.readNBT((Object)this.xpTank, null, tag.func_74781_a("xpTank"));
        }
        CompoundNBT compoundnbt = tag.func_74775_l("RecipesUsed");
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, tag.func_74781_a("energyStorage"));
        for (String s : compoundnbt.func_150296_c()) {
            this.recipes.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
        this.show_inventory_settings = tag.func_74762_e("ShowInvSettings");
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((CompoundNBT)tag, (NonNullList)this.inventory);
        tag.func_74768_a("BurnTime", this.furnaceBurnTime);
        tag.func_74768_a("CookTime", this.cookTime);
        tag.func_74768_a("CookTimeTotal", this.totalCookTime);
        tag.func_218657_a("fluidTank", CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.writeNBT((Object)this.fluidTank, null));
        tag.func_218657_a("xpTank", CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.writeNBT((Object)this.xpTank, null));
        tag.func_218657_a("energyStorage", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null));
        tag.func_74768_a("ShowInvSettings", this.show_inventory_settings);
        CompoundNBT compoundnbt = new CompoundNBT();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.func_74768_a(recipeId.toString(), craftedAmount.intValue()));
        tag.func_218657_a("RecipesUsed", (INBT)compoundnbt);
        return tag;
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(item, 0) : ret));
    }

    public static boolean isItemFuel(ItemStack stack) {
        return BlockSmeltingTileBase.getBurnTime(stack) > 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.func_145837_r()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
                if (facing == Direction.DOWN) {
                    return this.invHandlers[0].cast();
                }
                if (facing == Direction.UP) {
                    return this.invHandlers[1].cast();
                }
                if (facing == Direction.NORTH) {
                    return this.invHandlers[2].cast();
                }
                if (facing == Direction.SOUTH) {
                    return this.invHandlers[3].cast();
                }
                if (facing == Direction.WEST) {
                    return this.invHandlers[4].cast();
                }
                return this.invHandlers[5].cast();
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                if (facing == null || facing.ordinal() == this.getIndexTop() || facing.ordinal() == this.getIndexBottom()) {
                    if (this.isLiquid()) {
                        return LazyOptional.of(() -> this.fluidTank).cast();
                    }
                } else if (this.hasXPTank()) {
                    return LazyOptional.of(() -> this.xpTank).cast();
                }
            }
            if (this.hasUpgrade((Item)Registration.ENERGY.get()) && capability == CapabilityEnergy.ENERGY) {
                return LazyOptional.of(() -> this.energyStorage).cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public int getIndexBottom() {
        return 0;
    }

    public int getIndexTop() {
        return 1;
    }

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        if (this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 0) {
                return new int[0];
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 1) {
                return this.ISLOTS();
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 2) {
                return this.OUTPUTS();
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 3) {
                return this.FSLOTS();
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 4) {
                return new int[]{this.FUEL()};
            }
        } else {
            if (side == Direction.UP) {
                return this.INPUTS();
            }
            if (side == Direction.DOWN) {
                return this.OUTPUTS();
            }
            return new int[]{this.FUEL()};
        }
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        if (this.hasUpgradeType((ItemUpgrade)Registration.FACTORY.get())) {
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 0) {
                return false;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 1) {
                return false;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 2) {
                return index >= this.FOUTPUT() && index <= this.LOUTPUT();
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 3) {
                return index >= this.FOUTPUT() && index <= this.LOUTPUT();
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.func_77973_b() != Items.field_151133_ar) {
                return false;
            }
            if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.func_77973_b() == Items.field_151133_ar) {
                return true;
            }
        } else if (direction == Direction.DOWN && index >= this.FOUTPUT() && index <= this.LOUTPUT()) {
            return true;
        }
        return false;
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (index >= this.FOUTPUT() && index <= this.LOUTPUT()) {
            return false;
        }
        if (index >= this.FINPUT() && index <= this.LINPUT()) {
            if (stack.func_190926_b()) {
                return false;
            }
            return this.hasRecipe(stack);
        }
        if (index == this.FUEL()) {
            ItemStack itemstack = this.func_70301_a(this.FUEL());
            return BlockSmeltingTileBase.getBurnTime(stack) > 0 || stack.func_77973_b() == Items.field_151133_ar && itemstack.func_77973_b() != Items.field_151133_ar;
        }
        if (index > this.LOUTPUT()) {
            return (stack.func_77973_b() instanceof ItemUpgrade || stack.func_77973_b() instanceof ItemUpgradeLiquidFuel && !(this instanceof BlockForgeTileBase)) && !this.hasUpgrade(stack.func_77973_b()) && !this.hasUpgradeType((ItemUpgrade)stack.func_77973_b());
        }
        return false;
    }

    public void checkXP(@Nullable IRecipe<?> recipe) {
        if (!this.field_145850_b.field_72995_K) {
            boolean flag2 = false;
            if (this.recipes.size() > (Integer)Config.furnaceXPDropValue.get()) {
                this.grantStoredRecipeExperience(this.field_145850_b, new Vector3d((double)(this.field_174879_c.func_177958_n() + this.rand.nextInt(2) - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + this.rand.nextInt(2) - 1)));
                this.recipes.clear();
            } else {
                for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                    if (!this.field_145850_b.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).isPresent() || entry.getIntValue() <= (Integer)Config.furnaceXPDropValue2.get()) continue;
                    if (!flag2) {
                        this.grantStoredRecipeExperience(this.field_145850_b, new Vector3d((double)(this.field_174879_c.func_177958_n() + this.rand.nextInt(2) - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() + this.rand.nextInt(2) - 1)));
                    }
                    flag2 = true;
                }
                if (flag2) {
                    this.recipes.clear();
                }
            }
        }
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.func_199560_c();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void unlockRecipes(PlayerEntity player) {
        List<IRecipe<?>> list = this.grantStoredRecipeExperience(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(list);
        this.recipes.clear();
    }

    public List<IRecipe<?>> grantStoredRecipeExperience(World level, Vector3d worldPosition) {
        ArrayList list = Lists.newArrayList();
        if (this.recipes.object2IntEntrySet() != null) {
            for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                level.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(h -> {
                    list.add(h);
                    int amountLiquidXp = MathHelper.func_76141_d((float)((float)entry.getIntValue() * ((AbstractCookingRecipe)h).func_222138_b())) * 5;
                    if (this.hasXPTank()) {
                        if (amountLiquidXp >= 1) {
                            this.xpTank.fill(new FluidStack((Fluid)Objects.requireNonNull(ForgeRegistries.FLUIDS.getValue(new ResourceLocation(Config.getLiquidXPType()))), amountLiquidXp), IFluidHandler.FluidAction.EXECUTE);
                            this.recipes.clear();
                        }
                    } else if (worldPosition != null) {
                        BlockSmeltingTileBase.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), ((AbstractCookingRecipe)h).func_222138_b());
                    }
                });
            }
        }
        return list;
    }

    private static void splitAndSpawnExperience(World level, Vector3d worldPosition, int craftedAmount, float experience) {
        int i = MathHelper.func_76141_d((float)((float)craftedAmount * experience));
        float f = MathHelper.func_226164_h_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            level.func_217376_c((Entity)new ExperienceOrbEntity(level, worldPosition.field_72450_a, worldPosition.field_72448_b, worldPosition.field_72449_c, j));
        }
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.func_194112_a(itemstack);
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
    }
}

