/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item;

import com.focamacho.ringsofascension.RingsOfAscension;
import com.focamacho.ringsofascension.init.ModItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class ItemRingBase
extends Item {
    protected String tooltip;
    private final List<ResourceLocation> locations = new ArrayList<ResourceLocation>();

    public ItemRingBase(Item.Properties properties, String name, String tooltip) {
        super(properties.func_200916_a(RingsOfAscension.tabGroup));
        this.setRegistryName(name);
        this.tooltip = tooltip;
        ModItems.allItems.add(this);
    }

    public abstract boolean isEnabled();

    protected List<ResourceLocation> getLocations(String locations) {
        if (this.locations.isEmpty() && !locations.isEmpty()) {
            for (String location : locations.split(";")) {
                try {
                    String[] split = location.split(":");
                    this.locations.add(new ResourceLocation(split[0], split[1]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.locations;
    }

    public abstract List<ResourceLocation> getLocations();

    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
    }

    public Multimap<Attribute, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        HashMultimap modifiers = HashMultimap.create();
        return modifiers;
    }

    public void onEquippedCurio(String identifier, LivingEntity livingEntity) {
    }

    public void onUnequippedCurio(String identifier, LivingEntity livingEntity) {
    }

    public abstract int getTier();

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> lazyCurio = LazyOptional.of(() -> new ICurio(){

                public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.tickCurio(identifier, index, livingEntity);
                }

                public void playRightClickEquipSound(LivingEntity livingEntity) {
                    livingEntity.field_70170_p.func_184148_a(null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_187722_q, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }

                public void onEquip(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.onEquippedCurio(identifier, livingEntity);
                }

                @Nonnull
                public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                    return ICurio.DropRule.DEFAULT;
                }

                public void onUnequip(String identifier, int index, LivingEntity livingEntity) {
                    ItemRingBase.this.onUnequippedCurio(identifier, livingEntity);
                }

                public boolean canRightClickEquip() {
                    return true;
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
                    return ItemRingBase.this.curioModifiers(stack, identifier);
                }
            });

            public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
                return CuriosCapability.ITEM.orEmpty(capability, this.lazyCurio);
            }
        };
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        switch (this.getTier()) {
            case 0: {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier").getString() + " " + TextFormatting.GREEN + new TranslationTextComponent("tooltip.ringsofascension.tier.common").getString()));
                break;
            }
            case 1: {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier").getString() + " " + TextFormatting.BLUE + new TranslationTextComponent("tooltip.ringsofascension.tier.rare").getString()));
                break;
            }
            case 2: {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier").getString() + " " + TextFormatting.LIGHT_PURPLE + new TranslationTextComponent("tooltip.ringsofascension.tier.epic").getString()));
                break;
            }
            case 3: {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier").getString() + " " + TextFormatting.RED + new TranslationTextComponent("tooltip.ringsofascension.tier.legendary").getString()));
                break;
            }
            case 4: {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.tier").getString() + " " + TextFormatting.DARK_RED + new TranslationTextComponent("tooltip.ringsofascension.tier.mythic").getString()));
            }
        }
        if (this.tooltip == null) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent("tooltip.ringsofascension.worn").getString()));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + new TranslationTextComponent(this.tooltip).getString()));
    }
}

