/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item.rings;

import com.focamacho.ringsofascension.config.ConfigHolder;
import com.focamacho.ringsofascension.item.ItemRingBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemRingGrowth
extends ItemRingBase {
    private int timer = 200;

    public ItemRingGrowth(Item.Properties properties, String name, String tooltip) {
        super(properties, name, tooltip);
    }

    @Override
    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        if (this.timer <= 0) {
            this.timer = 200;
            BlockPos entityPos = new BlockPos(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
            int range = 5;
            int limit = 0;
            for (BlockPos pos : BlockPos.func_191531_b((int)(entityPos.func_177958_n() - range), (int)(entityPos.func_177956_o() - range), (int)(entityPos.func_177952_p() - range), (int)(entityPos.func_177958_n() + range), (int)(entityPos.func_177956_o() + range), (int)(entityPos.func_177952_p() + range))) {
                if (limit <= 3) {
                    BlockState state = livingEntity.field_70170_p.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof CropsBlock) && !(state.func_177230_c() instanceof StemBlock) || !BoneMealItem.applyBonemeal((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)livingEntity.field_70170_p, (BlockPos)pos, (PlayerEntity)((PlayerEntity)livingEntity))) continue;
                    ++limit;
                    if (state == livingEntity.field_70170_p.func_180495_p(pos)) continue;
                    livingEntity.field_70170_p.func_217379_c(2005, pos, 0);
                    continue;
                }
                break;
            }
        } else {
            --this.timer;
        }
    }

    @Override
    public List<ResourceLocation> getLocations() {
        return super.getLocations(ConfigHolder.ringLocationGrowth);
    }

    @Override
    public boolean isEnabled() {
        return ConfigHolder.ringGrowth;
    }

    @Override
    public int getTier() {
        return ConfigHolder.ringTierGrowth;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.isEnabled()) {
            return;
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

