/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item.rings;

import com.focamacho.ringsofascension.config.ConfigHolder;
import com.focamacho.ringsofascension.item.ItemRingBase;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import top.theillusivec4.curios.api.CuriosApi;

public class ItemRingHealth
extends ItemRingBase {
    private static final UUID HEALTH_UUID = UUID.fromString("b29c34f3-1450-48ff-ab28-639647e11861");

    public ItemRingHealth(Item.Properties properties, String name, String tooltip) {
        super(properties, name, tooltip);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        HashMultimap modifiers = HashMultimap.create();
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.func_77973_b()).contains(identifier) && this.isEnabled()) {
            modifiers.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(HEALTH_UUID, "Max Health", (double)(ConfigHolder.ringHealthHearts * 2), AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    @Override
    public List<ResourceLocation> getLocations() {
        return super.getLocations(ConfigHolder.ringLocationHealth);
    }

    @Override
    public boolean isEnabled() {
        return ConfigHolder.ringHealth;
    }

    @Override
    public int getTier() {
        return ConfigHolder.ringTierHealth;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.isEnabled()) {
            return;
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

