/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.nbt.CompoundNBT;

public class Vector2 {
    public double x;
    public double y;

    public Vector2() {
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(Vector2 vec) {
        this.x = vec.x;
        this.y = vec.y;
    }

    public static Vector2 fromNBT(CompoundNBT tag) {
        return new Vector2(tag.func_74769_h("x"), tag.func_74769_h("y"));
    }

    public CompoundNBT writeToNBT(CompoundNBT tag) {
        tag.func_74780_a("x", this.x);
        tag.func_74780_a("y", this.y);
        return tag;
    }

    public double[] toArrayD() {
        return new double[]{this.x, this.y};
    }

    public float[] toArrayF() {
        return new float[]{(float)this.x, (float)this.y};
    }

    public Vector2 set(double x1, double y1) {
        this.x = x1;
        this.y = y1;
        return this;
    }

    public Vector2 set(double d) {
        return this.set(d, d);
    }

    public Vector2 set(Vector2 vec) {
        return this.set(vec.x, vec.y);
    }

    public Vector2 set(double[] da) {
        return this.set(da[0], da[1]);
    }

    public Vector2 set(float[] fa) {
        return this.set(fa[0], fa[1]);
    }

    public Vector2 add(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Vector2 add(double d) {
        return this.add(d, d);
    }

    public Vector2 add(Vector2 vec) {
        return this.add(vec.x, vec.y);
    }

    public Vector2 subtract(double dx, double dy) {
        this.x -= dx;
        this.y -= dy;
        return this;
    }

    public Vector2 subtract(double d) {
        return this.subtract(d, d);
    }

    public Vector2 subtract(Vector2 vec) {
        return this.subtract(vec.x, vec.y);
    }

    public Vector2 multiply(double fx, double fy) {
        this.x *= fx;
        this.y *= fy;
        return this;
    }

    public Vector2 multiply(double f) {
        return this.multiply(f, f);
    }

    public Vector2 multiply(Vector2 f) {
        return this.multiply(f.x, f.y);
    }

    public Vector2 divide(double fx, double fy) {
        this.x /= fx;
        this.y /= fy;
        return this;
    }

    public Vector2 divide(double f) {
        return this.divide(f, f);
    }

    public Vector2 divide(Vector2 vec) {
        return this.divide(vec.x, vec.y);
    }

    public Vector2 floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        return this;
    }

    public Vector2 ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double magSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2 negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2 normalize() {
        double d = this.mag();
        if (d != 0.0) {
            this.multiply(1.0 / d);
        }
        return this;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public int hashCode() {
        long j = Double.doubleToLongBits(this.x);
        int i = (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.y);
        i = 31 * i + (int)(j ^ j >>> 32);
        return i;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (!(o instanceof Vector2)) {
            return false;
        }
        Vector2 v = (Vector2)o;
        return this.x == v.x && this.y == v.y;
    }

    public Vector2 copy() {
        return new Vector2(this);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector2(" + new BigDecimal(this.x, cont) + ", " + new BigDecimal(this.y, cont) + ")";
    }

    public double distanceSq(double toX, double toY) {
        double dx = this.x - toX;
        double dy = this.y - toY;
        return dx * dx + dy * dy;
    }

    public double distanceSq(Vector2 other) {
        double dx = this.x - other.x;
        double dy = this.y - other.y;
        return dx * dx + dy * dy;
    }

    public double distance(Vector2 other) {
        return Math.sqrt(this.distanceSq(other));
    }

    public double distance(double toX, double toY) {
        return Math.sqrt(this.distanceSq(toX, toY));
    }
}

