/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.lib.IValueHashable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class SerializationFlags<D extends INBTSerializable<CompoundNBT>> {
    protected final String tagName;
    protected final D serializableInstance;
    protected Object lastData;
    protected boolean saveTile = false;
    protected boolean saveItem = false;
    protected boolean syncTile = false;
    protected boolean syncContainer = false;

    public SerializationFlags(String tagName, D serializableInstance) {
        this.tagName = tagName;
        this.serializableInstance = serializableInstance;
        if (serializableInstance instanceof IValueHashable) {
            this.lastData = ((IValueHashable)serializableInstance).getValueHash();
            this.syncContainer = true;
        } else {
            this.lastData = serializableInstance.serializeNBT();
        }
    }

    public D getData() {
        return this.serializableInstance;
    }

    public SerializationFlags<D> saveItem() {
        this.saveItem = true;
        return this;
    }

    public SerializationFlags<D> saveTile() {
        this.saveTile = true;
        return this;
    }

    public SerializationFlags<D> saveBoth() {
        this.saveItem();
        this.saveTile();
        return this;
    }

    public SerializationFlags<D> syncTile() {
        this.syncTile = true;
        return this;
    }

    public SerializationFlags<D> syncContainer() {
        this.syncContainer = true;
        return this;
    }

    protected boolean hasChanged(boolean reset) {
        if (this.serializableInstance instanceof IValueHashable) {
            if (!((IValueHashable)this.serializableInstance).checkValueHash(this.lastData)) {
                if (reset) {
                    this.lastData = ((IValueHashable)this.serializableInstance).getValueHash();
                }
                return true;
            }
        } else if (!((CompoundNBT)this.serializableInstance.serializeNBT()).equals(this.lastData)) {
            if (reset) {
                this.lastData = this.serializableInstance.serializeNBT();
            }
            return true;
        }
        return false;
    }
}

