/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;

public class ThemedElements {
    public static int getBgLight() {
        return BCConfig.darkMode ? -10790053 : -1;
    }

    public static int getBgDark() {
        return BCConfig.darkMode ? -14145496 : -11513776;
    }

    public static int getBgFill() {
        return BCConfig.darkMode ? -12829636 : -3750202;
    }

    public static int getLightScroll() {
        return BCConfig.darkMode ? -10658200 : -1;
    }

    public static int getDarkScroll() {
        return BCConfig.darkMode ? -13290187 : -11513776;
    }

    public static class TestDialog
    extends GuiElement<TestDialog> {
        private GuiPickColourDialog background;
        private GuiPickColourDialog border;
        private GuiPickColourDialog scroll;

        @Override
        public void addChildElements() {
            super.addChildElements();
            this.background = new GuiPickColourDialog(this);
            this.background.setPos(this.screenWidth / 2 - 90, this.screenHeight / 2);
            this.background.setIncludeAlpha(true);
            this.background.setColour(-267386864);
            this.background.setCloseOnOutsideClick(false);
            this.border = new GuiPickColourDialog(this);
            this.border.setPos(this.screenWidth / 2 - 180, this.screenHeight / 2);
            this.border.setIncludeAlpha(true);
            this.border.setColour(-1862270977);
            this.border.setCloseOnOutsideClick(false);
            this.scroll = new GuiPickColourDialog(this);
            this.scroll.setPos(this.screenWidth / 2 - 270, this.screenHeight / 2);
            this.scroll.setIncludeAlpha(true);
            this.scroll.setColour(-1862270977);
            this.scroll.setCloseOnOutsideClick(false);
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            ((TestDialog)this.setPos(this.screenWidth / 2 + 10, this.screenHeight / 2)).setSize(150, 50);
            int backgroundColor = this.background.getColourARGB();
            int borderColorStart = this.border.getColourARGB();
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            getter.func_228461_a_();
        }
    }

    public static class ScrollBar
    extends GuiElement<ScrollBar> {
        private boolean background;
        private Supplier<Boolean> dragging = () -> false;

        public ScrollBar(boolean background) {
            this.background = background;
        }

        @Override
        public void reloadElement() {
            super.reloadElement();
            GuiElement parent = this.getParent();
            if (parent instanceof GuiSlideControl) {
                this.dragging = ((GuiSlideControl)parent)::isDragging;
            }
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            if (this.background) {
                boolean highlight = this.isMouseOver(mouseX, mouseY) || this.dragging.get() != false;
                this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), GuiElement.mixColours(ThemedElements.getBgFill(), 0x303030 + (highlight ? 0x151515 : 0), !BCConfig.darkMode));
            } else {
                int light = ThemedElements.getLightScroll();
                int dark = ThemedElements.getDarkScroll();
                this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, ScrollBar.midColour(light, dark), light, dark, ScrollBar.midColour(light, dark));
            }
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public static class ContentRect
    extends GuiElement<ContentRect> {
        private Supplier<Boolean> inset;
        private boolean fill = true;

        public ContentRect() {
            this(false, true);
        }

        public ContentRect(boolean inset, boolean fill) {
            this(() -> inset, fill);
        }

        public ContentRect(Supplier<Boolean> inset, boolean fill) {
            this.inset = inset;
            this.fill = fill;
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            boolean inset = this.inset.get();
            int light = inset ? ThemedElements.getBgDark() : ThemedElements.getBgLight();
            int dark = inset ? ThemedElements.getBgLight() : ThemedElements.getBgDark();
            int fill = ThemedElements.getBgFill();
            this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, light, dark, fill);
            this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos() + 1, this.xSize() - 2, this.ySize() - 2, 1.0, this.fill ? fill : 0, dark, light, fill);
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public static class ShadedRect
    extends GuiElement<ShadedRect> {
        private Supplier<Boolean> inset;
        private boolean fill;

        public ShadedRect() {
            this(false, true);
        }

        public ShadedRect(boolean inset, boolean fill) {
            this(() -> inset, fill);
        }

        public ShadedRect(Supplier<Boolean> inset, boolean fill) {
            this.inset = inset;
            this.fill = fill;
        }

        @Override
        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            boolean inset = this.inset.get();
            int light = inset ? ThemedElements.getBgLight() : ThemedElements.getBgDark();
            int dark = inset ? ThemedElements.getBgDark() : ThemedElements.getBgLight();
            this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, this.fill ? ThemedElements.getBgFill() : 0, dark, light, ThemedElements.getBgFill());
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

