/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiEntityRenderer
extends GuiElement<GuiEntityRenderer> {
    private static Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private static List<ResourceLocation> invalidEntities = new ArrayList<ResourceLocation>();
    private float rotationSpeed = 1.0f;
    private float lockedRotation = 0.0f;
    private Entity entity;
    private ResourceLocation entityName;
    private boolean invalidEntity = false;
    private boolean rotationLocked = false;
    private boolean trackMouse = false;
    private boolean drawName = false;
    public boolean silentErrors = false;
    public boolean force2dSize = false;

    public GuiEntityRenderer() {
    }

    public GuiEntityRenderer(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiEntityRenderer(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
    }

    public GuiEntityRenderer setEntity(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
            return this;
        }
        this.entityName = entity.func_200600_R().getRegistryName();
        this.invalidEntity = false;
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setEntity(ResourceLocation entity) {
        this.entityName = entity;
        this.entity = entityCache.computeIfAbsent(entity, resourceLocation -> {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
            return type == null ? null : type.func_200721_a((World)this.mc.field_71441_e);
        });
        this.invalidEntity = false;
        if (this.entity == null) {
            if (!this.silentErrors) {
                LogHelperBC.dev("GuiEntityRenderer#setEntity: Invalid Entity - " + this.entityName);
            }
            this.invalidEntity = true;
        }
        if (invalidEntities.contains(this.entityName)) {
            this.invalidEntity = true;
        }
        return this;
    }

    public GuiEntityRenderer setSilentErrors(boolean silentErrors) {
        this.silentErrors = silentErrors;
        return this;
    }

    public GuiEntityRenderer setForce2dSize(boolean force2dSize) {
        this.force2dSize = force2dSize;
        return this;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.invalidEntity && !this.silentErrors) {
            LogHelperBC.dev("GuiEntityRenderer: Invalid Entity - " + this.entityName);
            return;
        }
        try {
            if (this.entity != null) {
                float rotation;
                Rectangle rect = this.getInsetRect();
                float scale = this.force2dSize ? Math.min((float)rect.height / this.entity.func_213302_cg(), (float)rect.width / this.entity.func_213311_cf()) : (float)rect.height / this.entity.func_213302_cg();
                double zLevel = this.getRenderZLevel() + 100.0f;
                double posX = (double)rect.x + (double)rect.width / 2.0;
                int yPos = this.yPos() + this.ySize() / 2 + rect.height / 2;
                float f = rotation = this.isRotationLocked() ? this.getLockedRotation() : ((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.getRotationSpeedMultiplier();
                if (this.entity instanceof LivingEntity) {
                    int eyeOffset = (int)((this.entity.func_213302_cg() - this.entity.func_70047_e()) * scale);
                    RenderSystem.translated((double)0.0, (double)0.0, (double)zLevel);
                    GuiEntityRenderer.renderEntityOnScreen((int)posX, yPos, (int)scale, (int)posX - mouseX, this.yPos() - mouseY + eyeOffset, (LivingEntity)this.entity, rotation, this.trackMouse, this.drawName);
                    RenderSystem.translated((double)0.0, (double)0.0, (double)(-zLevel));
                }
            }
        }
        catch (Throwable e) {
            this.invalidEntity = true;
            invalidEntities.add(this.entityName);
            LogHelperBC.error("Failed to build entity in GUI. This is not a bug there are just some entities that can not be rendered like this.");
            LogHelperBC.error("Entity: " + this.entity);
            e.printStackTrace();
        }
    }

    public boolean isRotationLocked() {
        return this.rotationLocked;
    }

    public GuiEntityRenderer rotationLocked(boolean rotationLocked) {
        this.rotationLocked = rotationLocked;
        return this;
    }

    public GuiEntityRenderer setLockedRotation(float lockedRotation) {
        this.lockedRotation = lockedRotation;
        this.rotationLocked(true);
        return this;
    }

    public float getLockedRotation() {
        return this.lockedRotation;
    }

    public boolean isInvalidEntity() {
        return this.invalidEntity;
    }

    public GuiEntityRenderer setRotationSpeedMultiplier(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public GuiEntityRenderer setTrackMouse(boolean trackMouse) {
        this.trackMouse = trackMouse;
        return this;
    }

    public GuiEntityRenderer setDrawName(boolean drawName) {
        this.drawName = drawName;
        return this;
    }

    public float getRotationSpeedMultiplier() {
        return this.rotationSpeed;
    }

    public static void renderEntityOnScreen(int xPos, int yPos, int scale, float mouseX, float mouseY, LivingEntity entity, double rotation, boolean trackMouse, boolean drawName) {
        float lookY;
        float lookX = trackMouse ? (float)Math.atan(mouseX / 40.0f) : 0.0f;
        float f = lookY = trackMouse ? (float)Math.atan(mouseY / 40.0f) : 0.0f;
        if (drawName && entity instanceof RemoteClientPlayerEntity && Minecraft.func_71410_x().field_71439_g != null) {
            entity.func_70107_b(Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), Minecraft.func_71410_x().field_71439_g.func_226278_cu_(), Minecraft.func_71410_x().field_71439_g.func_226281_cx_());
        } else if (entity instanceof RemoteClientPlayerEntity) {
            entity.func_70107_b(0.0, -1000.0, 0.0);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xPos, (float)yPos, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(lookY * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation));
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + lookX * 20.0f;
        entity.field_70177_z = 180.0f + lookX * 40.0f;
        entity.field_70125_A = -lookY * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        rendererManager.func_229089_a_(quaternion1);
        rendererManager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> rendererManager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.func_228461_a_();
        rendererManager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public static PlayerEntity createRenderPlayer(ClientWorld world, String username) {
        return new RemoteClientPlayerEntity(world, SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = PlayerEntity.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(PlayerModelPart part) {
                return true;
            }
        };
    }
}

