/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityElement
extends MDElementBase<EntityElement> {
    private static final Logger LOGGER = LogManager.getLogger(EntityElement.class);
    private static Map<String, Entity> renderEntityCache = new HashMap<String, Entity>();
    public int xOffset = 0;
    public int yOffset = 0;
    public double rotateSpeed = 0.0;
    public double rotation = 0.0;
    public double drawScale = 1.0;
    public boolean animate = false;
    public boolean trackMouse = false;
    public boolean drawName = false;
    public String mainHand = "";
    public String offHand = "";
    public String head = "";
    public String chest = "";
    public String legs = "";
    public String boots = "";
    private Entity renderEntity = null;
    private String entityName;
    private boolean errored = false;
    boolean animateBroken = false;
    int animTick = 0;

    public EntityElement(String entityName) {
        this.entityName = entityName;
        this.size = 64;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.setSize(this.size, this.size);
        try {
            this.renderEntity = this.getRenderEntity(this.mc.field_71441_e, this.entityName, EquipmentHelper.create(this));
        }
        catch (IllegalArgumentException e) {
            this.error("[Broken Entity. " + e.getMessage() + "]");
        }
        if (this.trackMouse && !(this.renderEntity instanceof LivingEntity)) {
            this.error("[Broken Entity. track_mouse is only supported with living entities]");
        }
        if (this.drawName && !(this.renderEntity instanceof PlayerEntity)) {
            this.error("[Broken Entity. draw_name is only supported by player's]");
        }
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.errored || this.renderEntity == null) {
            return;
        }
        int xPos = this.xPos() + this.xOffset;
        int yPos = this.yPos() + this.yOffset;
        int scale = (int)((double)((float)this.size / Math.max(this.renderEntity.func_213302_cg(), this.renderEntity.func_213311_cf())) * this.drawScale);
        double posX = (double)xPos + (double)this.size / 2.0;
        double entityRotation = this.rotation + (double)((float)BCClientEventHandler.elapsedTicks + partialTicks) * this.rotateSpeed;
        this.renderEntity.field_70173_aa = BCClientEventHandler.elapsedTicks;
        double zLevel = 25.0f + this.getRenderZLevel() + (float)scale;
        try {
            if (this.renderEntity instanceof LivingEntity) {
                int eyeOffset = (int)((this.renderEntity.func_213302_cg() - this.renderEntity.func_70047_e()) * (float)scale);
                RenderSystem.translated((double)0.0, (double)0.0, (double)zLevel);
                EntityElement.renderEntityOnScreen((int)posX, yPos + this.ySize(), scale, (int)posX - mouseX, this.yPos() - mouseY + eyeOffset, (LivingEntity)this.renderEntity, entityRotation, this.trackMouse, this.drawName);
                RenderSystem.translated((double)0.0, (double)0.0, (double)(-zLevel));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong while attempting to render an entity on the screen!");
            LOGGER.error("Entity: " + this.renderEntity);
            e.printStackTrace();
            this.errored = true;
        }
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.tooltip.isEmpty() && !this.errored && this.renderEntity != null) {
            double ar = this.renderEntity.func_213302_cg() / this.renderEntity.func_213311_cf();
            double width = (double)this.size * this.drawScale;
            double height = (double)this.size * this.drawScale;
            if (ar > 1.0) {
                width *= (double)(this.renderEntity.func_213311_cf() / this.renderEntity.func_213302_cg());
            } else {
                height *= ar;
            }
            int x = (int)((double)(this.xPos() + this.xOffset) + ((double)this.xSize() - width) / 2.0);
            int y = (int)((double)this.yPos() + ((double)this.ySize() - height) + (double)this.yOffset);
            if (GuiHelperOld.isInRect(x, y, (int)width, (int)height, mouseX, mouseY)) {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public static void renderEntityOnScreen(int xPos, int yPos, int scale, float mouseX, float mouseY, LivingEntity entity, double rotation, boolean trackMouse, boolean drawName) {
        float lookY;
        float lookX = trackMouse ? (float)Math.atan(mouseX / 40.0f) : 0.0f;
        float f = lookY = trackMouse ? (float)Math.atan(mouseY / 40.0f) : 0.0f;
        if (drawName && entity instanceof RemoteClientPlayerEntity && Minecraft.func_71410_x().field_71439_g != null) {
            entity.func_70107_b(Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), Minecraft.func_71410_x().field_71439_g.func_226278_cu_(), Minecraft.func_71410_x().field_71439_g.func_226281_cx_());
        } else if (entity instanceof RemoteClientPlayerEntity) {
            entity.func_70107_b(0.0, -1000.0, 0.0);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xPos, (float)yPos, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(lookY * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation));
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + lookX * 20.0f;
        entity.field_70177_z = 180.0f + lookX * 40.0f;
        entity.field_70125_A = -lookY * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        rendererManager.func_229089_a_(quaternion1);
        rendererManager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> rendererManager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.func_228461_a_();
        rendererManager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public Entity getRenderEntity(ClientWorld world, String entityString, EquipmentHelper helper) {
        String ident = String.format("%s|mh:%s|oh:%s|h:%s|ch:%s|le:%s|bo:%s", entityString, this.mainHand, this.offHand, this.head, this.chest, this.legs, this.boots);
        if (renderEntityCache.containsKey(ident) && !this.animate) {
            return renderEntityCache.get(ident);
        }
        if (!entityString.contains(":")) {
            throw new IllegalArgumentException("Invalid entity string! Must be ether modid:entityName or player:username");
        }
        PlayerEntity entity = null;
        if (entityString.startsWith("player:")) {
            entity = EntityElement.createRenderPlayer(world, entityString.replaceFirst("player:", ""));
        } else {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityString));
            if (type != null) {
                entity = type.func_200721_a((World)world);
            }
        }
        if (entity == null) {
            throw new IllegalArgumentException("No matching entity found for string: " + entityString);
        }
        if (entity instanceof LivingEntity && helper.hasEquipment) {
            helper.apply((LivingEntity)entity);
        } else if (helper.hasEquipment) {
            throw new IllegalArgumentException("The specified entity does not allow equipment!");
        }
        if (!this.animate) {
            renderEntityCache.put(ident, (Entity)entity);
        }
        return entity;
    }

    public static PlayerEntity createRenderPlayer(ClientWorld world, String username) {
        return new RemoteClientPlayerEntity(world, SkullTileEntity.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = PlayerEntity.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(PlayerModelPart part) {
                return true;
            }
        };
    }

    @Override
    public boolean onUpdate() {
        if (this.animate && this.renderEntity != null && !this.errored && !this.animateBroken && this.animTick != BCClientEventHandler.elapsedTicks) {
            try {
                this.renderEntity.field_70173_aa = this.animTick;
                this.animTick = BCClientEventHandler.elapsedTicks;
                this.renderEntity.func_70071_h_();
            }
            catch (Throwable e) {
                this.animateBroken = true;
            }
        }
        return super.onUpdate();
    }

    static class EquipmentHelper {
        private ItemStack mainHand = ItemStack.field_190927_a;
        private ItemStack offHand = ItemStack.field_190927_a;
        private ItemStack head = ItemStack.field_190927_a;
        private ItemStack chest = ItemStack.field_190927_a;
        private ItemStack legs = ItemStack.field_190927_a;
        private ItemStack boots = ItemStack.field_190927_a;
        public boolean hasEquipment = false;

        EquipmentHelper() {
        }

        public void apply(LivingEntity entity) {
            if (!this.mainHand.func_190926_b()) {
                entity.func_184611_a(Hand.MAIN_HAND, this.mainHand);
            }
            if (!this.offHand.func_190926_b()) {
                entity.func_184611_a(Hand.OFF_HAND, this.offHand);
            }
            if (!this.head.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.HEAD, this.head);
            }
            if (!this.chest.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.CHEST, this.chest);
            }
            if (!this.legs.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.LEGS, this.legs);
            }
            if (!this.boots.func_190926_b()) {
                entity.func_184201_a(EquipmentSlotType.FEET, this.boots);
            }
        }

        public static EquipmentHelper create(EntityElement element) {
            EquipmentHelper helper = new EquipmentHelper();
            try {
                if (!element.mainHand.isEmpty()) {
                    helper.mainHand = StringyStacks.fromString(element.mainHand);
                    if (helper.mainHand.func_190926_b()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.mainHand);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.offHand.isEmpty()) {
                    helper.offHand = StringyStacks.fromString(element.offHand);
                    if (helper.offHand.func_190926_b()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.offHand);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.head.isEmpty()) {
                    helper.head = StringyStacks.fromString(element.head);
                    if (helper.head.func_190926_b()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.head);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.chest.isEmpty()) {
                    helper.chest = StringyStacks.fromString(element.chest);
                    if (helper.chest.func_190926_b()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.chest);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.legs.isEmpty()) {
                    helper.legs = StringyStacks.fromString(element.legs);
                    if (helper.legs.func_190926_b()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.legs);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
                if (!element.boots.isEmpty()) {
                    helper.boots = StringyStacks.fromString(element.boots);
                    if (helper.boots.func_190926_b()) {
                        LOGGER.warn("[MarkdownParser]: No matching item found for stack string: " + element.boots);
                    } else {
                        helper.hasEquipment = true;
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.warn("[Entity Element] An error occurred while parsing stack string.");
                e.printStackTrace();
            }
            return helper;
        }
    }
}

