/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.HAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.VAlign;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;

public abstract class MDElementBase<E extends GuiElement<E>>
extends GuiElement<E> {
    public static final char S = '\u00a7';
    public int size = 0;
    public int width = -1;
    public int height = -1;
    public List<String> tooltip = new ArrayList<String>();
    public boolean enableTooltip = true;
    public boolean screenRelativeSize = false;
    public HAlign hAlign = HAlign.LEFT;
    public VAlign vAlign = VAlign.TOP;
    protected int colour = 0;
    protected boolean hasColour = false;
    protected int colourHover = 0;
    protected boolean hasColourHover = false;
    protected int colourBorder = 0;
    protected boolean hasColourBorder = false;
    protected int colourBorderHover = 0;
    protected boolean hasColourBorderHover = false;
    public int leftPad = 0;
    public int rightPad = 0;
    public int topPad = 0;
    public int bottomPad = 0;
    private String elementError = "";
    public boolean hasSubParts = false;
    public LinkedList<MDElementBase> subParts = new LinkedList();
    public List<String> invalidProps = new ArrayList<String>();
    public List<String> errors = new ArrayList<String>();

    public MDElementBase() {
    }

    public MDElementBase(int xSize, int ySize) {
        this.setSize(xSize, ySize);
    }

    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        Point pos = layout.nextElementPos(this.xSize(), this.ySize());
        this.setPos(pos.x, pos.y);
    }

    public void error(String errorMessage) {
        if (!this.errors.contains(errorMessage)) {
            this.errors.add(errorMessage);
        }
        this.elementError = this.elementError.isEmpty() ? errorMessage : this.elementError + " and " + errorMessage;
    }

    public String getError() {
        return this.elementError;
    }

    public void setColour(int colour) {
        this.colour = colour;
        this.hasColour = true;
    }

    public void setColourBorder(int colourBorder) {
        this.colourBorder = colourBorder;
        this.hasColourBorder = true;
    }

    public void setColourHover(int colourHover) {
        this.colourHover = colourHover;
        this.hasColourHover = true;
    }

    public void setColourBorderHover(int colourBorderHover) {
        this.colourBorderHover = colourBorderHover;
        this.hasColourBorderHover = true;
    }

    public int getColour(boolean mouseOver) {
        if (mouseOver && this.hasColourHover) {
            return this.colourHover;
        }
        return this.colour;
    }

    public int getColourBorder(boolean mouseOver) {
        if (mouseOver && this.hasColourBorderHover) {
            return this.colourBorderHover;
        }
        return this.colourBorder;
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.invalidProps.isEmpty() && this.yPos() > 0 && this.yPos() < this.screenHeight) {
            ArrayList<String> list = new ArrayList<String>();
            this.invalidProps.forEach(s -> list.add("\u00a7cProperty \"" + s + "\" is invalid or not supported by this tag!" + '\u00a7' + "c"));
            this.errors.forEach(s -> list.add("\u00a7c" + s + '\u00a7' + "c"));
            this.zOffset += 100.0;
            this.drawHoveringText(list, this.xPos() - 8, this.yPos() + 15, this.fontRenderer, this.screenWidth, this.screenHeight);
            this.zOffset -= 100.0;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }
}

