/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class CommandTPX {
    private static Random rand = new Random();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpx").requires(p_198816_0_ -> p_198816_0_.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(ctx -> CommandTPX.teleportToPos((CommandSource)ctx.getSource(), Collections.singleton(((CommandSource)ctx.getSource()).func_197027_g()), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), null, null))).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> CommandTPX.teleportToPos((CommandSource)ctx.getSource(), Collections.singleton(((CommandSource)ctx.getSource()).func_197027_g()), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), null))))).then(Commands.func_197056_a((String)"destination", (ArgumentType)EntityArgument.func_197086_a()).executes(ctx -> CommandTPX.teleportToEntity((CommandSource)ctx.getSource(), Collections.singleton(((CommandSource)ctx.getSource()).func_197027_g()), EntityArgument.func_197088_a((CommandContext)ctx, (String)"destination"))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"destination", (ArgumentType)EntityArgument.func_197086_a()).executes(ctx -> CommandTPX.teleportToEntity((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets"), EntityArgument.func_197088_a((CommandContext)ctx, (String)"destination"))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(ctx -> CommandTPX.teleportToPos((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), new EntityLocation(((CommandSource)ctx.getSource()).func_197027_g()), null))).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> CommandTPX.teleportToPos((CommandSource)ctx.getSource(), EntityArgument.func_197097_b((CommandContext)ctx, (String)"targets"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), null))))));
    }

    private static int teleportToEntity(CommandSource source, Collection<? extends Entity> targets, Entity destination) {
        for (Entity entity : targets) {
            CommandTPX.teleport(source, entity, (ServerWorld)destination.field_70170_p, destination.func_226277_ct_(), destination.func_226278_cu_(), destination.func_226281_cx_(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class), destination.field_70177_z, destination.field_70125_A);
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.entity.single", new Object[]{targets.iterator().next().func_145748_c_(), destination.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.entity.multiple", new Object[]{targets.size(), destination.func_145748_c_()}), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSource source, Collection<? extends Entity> targets, ServerWorld targetWorld, @Nullable ILocationArgument position, @Nullable ILocationArgument rotationIn) throws CommandSyntaxException {
        if (position == null) {
            BlockPos pos = new BlockPos(0, 127, 0);
            rand.setSeed(0L);
            for (int i = 0; i < 1000; ++i) {
                pos = i < 500 ? new BlockPos(-150 + rand.nextInt(300), 32 + rand.nextInt(80), -150 + rand.nextInt(300)) : new BlockPos(-250 + rand.nextInt(500), 256, -250 + rand.nextInt(500));
                if (!targetWorld.func_175623_d(pos)) continue;
                while (targetWorld.func_175623_d(pos.func_177977_b()) && World.func_175701_a((BlockPos)pos.func_177977_b())) {
                    pos = pos.func_177977_b();
                }
                BlockState state = targetWorld.func_180495_p(pos.func_177977_b());
                if (state.func_204520_s().func_206888_e() && state.func_185904_a().func_76230_c()) break;
            }
            position = new BlockLocation(pos);
        }
        Vector3d vec3d = position.func_197281_a(source);
        Vector2f vec2f = rotationIn == null ? null : rotationIn.func_197282_b(source);
        EnumSet<SPlayerPositionLookPacket.Flags> set = EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class);
        if (position.func_200380_a()) {
            set.add(SPlayerPositionLookPacket.Flags.X);
        }
        if (position.func_200381_b()) {
            set.add(SPlayerPositionLookPacket.Flags.Y);
        }
        if (position.func_200382_c()) {
            set.add(SPlayerPositionLookPacket.Flags.Z);
        }
        if (rotationIn == null) {
            set.add(SPlayerPositionLookPacket.Flags.X_ROT);
            set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
        } else {
            if (rotationIn.func_200380_a()) {
                set.add(SPlayerPositionLookPacket.Flags.X_ROT);
            }
            if (rotationIn.func_200381_b()) {
                set.add(SPlayerPositionLookPacket.Flags.Y_ROT);
            }
        }
        for (Entity entity : targets) {
            if (rotationIn == null) {
                CommandTPX.teleport(source, entity, targetWorld, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, set, entity.field_70177_z, entity.field_70125_A);
                continue;
            }
            CommandTPX.teleport(source, entity, targetWorld, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, set, vec2f.field_189983_j, vec2f.field_189982_i);
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.location.single", new Object[]{targets.iterator().next().func_145748_c_(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.teleport.success.location.multiple", new Object[]{targets.size(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c}), true);
        }
        return targets.size();
    }

    private static void teleport(CommandSource source, Entity entityIn, ServerWorld worldIn, double x, double y, double z, Set<SPlayerPositionLookPacket.Flags> relativeList, float yaw, float pitch) {
        if (entityIn instanceof ServerPlayerEntity) {
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            worldIn.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)entityIn.func_145782_y());
            entityIn.func_184210_p();
            if (((ServerPlayerEntity)entityIn).func_70608_bn()) {
                ((ServerPlayerEntity)entityIn).func_213366_dy();
            }
            if (worldIn == entityIn.field_70170_p) {
                ((ServerPlayerEntity)entityIn).field_71135_a.func_175089_a(x, y, z, yaw, pitch, relativeList);
            } else {
                ((ServerPlayerEntity)entityIn).func_200619_a(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.func_70034_d(yaw);
        } else {
            float f1 = MathHelper.func_76142_g((float)yaw);
            float f = MathHelper.func_76142_g((float)pitch);
            f = MathHelper.func_76131_a((float)f, (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.field_70170_p) {
                entityIn.func_70012_b(x, y, z, f1, f);
                entityIn.func_70034_d(f1);
            } else {
                entityIn.func_213319_R();
                entityIn.func_241206_a_(worldIn);
                Entity entity = entityIn;
                entityIn = entityIn.func_200600_R().func_200721_a((World)worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.func_180432_n(entity);
                entityIn.func_70012_b(x, y, z, f1, f);
                entityIn.func_70034_d(f1);
                worldIn.func_217460_e(entityIn);
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).func_184613_cA()) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            entityIn.func_230245_c_(true);
        }
    }

    private static class BlockLocation
    implements ILocationArgument {
        private BlockPos pos;

        public BlockLocation(BlockPos pos) {
            this.pos = pos;
        }

        public Vector3d func_197281_a(CommandSource source) {
            return Vector3d.func_237489_a_((Vector3i)this.pos);
        }

        public Vector2f func_197282_b(CommandSource source) {
            return source.func_201004_i();
        }

        public boolean func_200380_a() {
            return false;
        }

        public boolean func_200381_b() {
            return false;
        }

        public boolean func_200382_c() {
            return false;
        }
    }

    private static class EntityLocation
    implements ILocationArgument {
        private Entity entity;

        public EntityLocation(Entity entity) {
            this.entity = entity;
        }

        public Vector3d func_197281_a(CommandSource source) {
            return this.entity.func_213303_ch();
        }

        public Vector2f func_197282_b(CommandSource source) {
            return source.func_201004_i();
        }

        public boolean func_200380_a() {
            return false;
        }

        public boolean func_200381_b() {
            return false;
        }

        public boolean func_200382_c() {
            return false;
        }
    }
}

