/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.integration;

import com.brandon3055.brandonscore.integration.BCJEIPlugin;
import com.brandon3055.brandonscore.integration.IRecipeRenderer;
import com.brandon3055.brandonscore.integration.ModHelperBC;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;

public class JeiHelper {
    public static boolean jeiAvailable() {
        if (!ModHelperBC.isJEIInstalled) {
            return false;
        }
        return JeiHelper.checkJEIRuntime();
    }

    public static boolean checkJEIRuntime() {
        return BCJEIPlugin.jeiRuntime != null;
    }

    public static List<IRecipeRenderer> getRecipeRenderers(ItemStack result) {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        return JeiHelper.getRenderers(result);
    }

    private static List<IRecipeRenderer> getRenderers(ItemStack result) {
        ArrayList<IRecipeRenderer> renderers = new ArrayList<IRecipeRenderer>();
        IRecipeManager registry = BCJEIPlugin.jeiRuntime.getRecipeManager();
        LinkedList categories = new LinkedList(registry.getRecipeCategories(registry.createFocus(IFocus.Mode.OUTPUT, (Object)result)));
        for (IRecipeCategory category : categories) {
            List wrappers = registry.getRecipes(category, registry.createFocus(IFocus.Mode.OUTPUT, (Object)result));
            for (Object wrapper : wrappers) {
                try {
                    renderers.add(new RecipeRenderer(category, wrapper, result));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return renderers;
    }

    public static void openJEIRecipe(ItemStack stack, boolean usage) {
        if (JeiHelper.jeiAvailable()) {
            JeiHelper.openJEIRecipeInternal(stack, usage);
        }
    }

    private static void openJEIRecipeInternal(ItemStack stack, boolean usage) {
        if (JeiHelper.checkJEIRuntime()) {
            IFocus f = BCJEIPlugin.jeiRuntime.getRecipeManager().createFocus(usage ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT, (Object)stack);
            BCJEIPlugin.jeiRuntime.getRecipesGui().show(f);
        }
    }

    public static int getRecipeKey(boolean usage) {
        if (JeiHelper.jeiAvailable()) {
            return JeiHelper.getRecipeKeyInternal(usage);
        }
        return -1;
    }

    private static int getRecipeKeyInternal(boolean usage) {
        try {
            return usage ? KeyBindings.showUses.getKey().func_197937_c() : KeyBindings.showRecipe.getKey().func_197937_c();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Nullable
    public static ItemStack getPanelItemUnderMouse() {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        Object ingredient = BCJEIPlugin.jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse();
        if (ingredient == null) {
            return null;
        }
        IIngredientHelper helper = BCJEIPlugin.jeiRuntime.getIngredientManager().getIngredientHelper(ingredient);
        return helper.getCheatItemStack(ingredient);
    }

    private static class RecipeRenderer
    implements IRecipeRenderer {
        private IRecipeLayoutDrawable recipeLayout;
        private int width;
        private int height;
        private int xPos = 0;
        private int yPos = 0;
        private String title;

        public RecipeRenderer(IRecipeCategory category, Object wrapper, ItemStack result) {
            IFocus f = BCJEIPlugin.jeiRuntime.getRecipeManager().createFocus(IFocus.Mode.OUTPUT, (Object)result);
            this.recipeLayout = BCJEIPlugin.jeiRuntime.getRecipeManager().createRecipeLayoutDrawable(category, wrapper, f);
            this.width = category.getBackground().getWidth();
            this.height = category.getBackground().getHeight();
            this.title = category.getTitle();
            if (StringUtils.func_151246_b((String)this.title)) {
                this.title = "[Unknown Crafting Type]";
            }
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(Minecraft mc, int xPos, int yPos, int mouseX, int mouseY) {
            if (this.xPos != xPos || this.yPos != yPos) {
                this.xPos = xPos;
                this.yPos = yPos;
                this.recipeLayout.setPosition(xPos, yPos);
            }
            this.recipeLayout.drawRecipe(new MatrixStack(), mouseX, mouseY);
        }

        @Override
        public void renderOverlay(Minecraft mc, int mouseX, int mouseY) {
            this.recipeLayout.drawOverlays(new MatrixStack(), mouseX, mouseY);
        }

        @Override
        public boolean handleRecipeClick(Minecraft minecraft, double mouseX, double mouseY, boolean usage) {
            Object clicked = this.recipeLayout.getIngredientUnderMouse((int)mouseX, (int)mouseY);
            if (clicked != null) {
                IFocus f = BCJEIPlugin.jeiRuntime.getRecipeManager().createFocus(usage ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT, clicked);
                BCJEIPlugin.jeiRuntime.getRecipesGui().show(f);
            }
            return false;
        }

        @Override
        @Nullable
        public Object getIngredientUnderMouse(double mouseX, double mouseY) {
            return this.recipeLayout.getIngredientUnderMouse((int)mouseX, (int)mouseY);
        }

        @Override
        public String getTitle() {
            return this.title;
        }
    }
}

