/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

@Deprecated
public class Vec3D {
    public double x;
    public double y;
    public double z;

    public Vec3D() {
    }

    public Vec3D(Entity entity) {
        this.x = entity.func_226277_ct_();
        this.y = entity.func_226278_cu_();
        this.z = entity.func_226281_cx_();
    }

    public Vec3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3D(Vec3D vec3I) {
        this.x = vec3I.x;
        this.y = vec3I.y;
        this.z = vec3I.z;
    }

    public Vec3D(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public Vec3D(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public Vec3D set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vec3D set(Vec3D vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    public Vec3D set(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        return this;
    }

    public Vec3D add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec3D add(Vec3D vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vec3D add(BlockPos pos) {
        this.x += (double)pos.func_177958_n();
        this.y += (double)pos.func_177956_o();
        this.z += (double)pos.func_177952_p();
        return this;
    }

    public Vec3D subtract(BlockPos pos) {
        this.x -= (double)pos.func_177958_n();
        this.y -= (double)pos.func_177956_o();
        this.z -= (double)pos.func_177952_p();
        return this;
    }

    public Vec3D subtract(Vec3D vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vec3D subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vec3D multiply(Vec3D vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public Vec3D multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vec3D copy() {
        return new Vec3D(this);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public Vector3 toVector3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public String toString() {
        return String.format("Vec3D: [x: %s, y: %s, z: %s]", this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vec3D other = (Vec3D)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return ((int)this.y + (int)this.z * 31) * 31 + (int)this.x;
    }

    public Vec3D offset(Direction direction, double offsetDistance) {
        this.x += (double)direction.func_82601_c() * offsetDistance;
        this.y += (double)direction.func_96559_d() * offsetDistance;
        this.z += (double)direction.func_82599_e() * offsetDistance;
        return this;
    }

    public Vec3D offset(Vec3D direction, double offsetDistance) {
        this.x += direction.x * offsetDistance;
        this.y += direction.y * offsetDistance;
        this.z += direction.z * offsetDistance;
        return this;
    }

    public Vec3D radialOffset(Direction.Axis axis, double sin, double cos, double offsetAmount) {
        this.x += (axis == Direction.Axis.X ? 0.0 : (axis == Direction.Axis.Y ? sin : sin)) * offsetAmount;
        this.y += (axis == Direction.Axis.X ? sin : (axis == Direction.Axis.Y ? 0.0 : cos)) * offsetAmount;
        this.z += (axis == Direction.Axis.X ? cos : (axis == Direction.Axis.Y ? cos : 0.0)) * offsetAmount;
        return this;
    }

    public static Vec3D getDirectionVec(Vec3D vecFrom, Vec3D vecTo) {
        double distance = Utils.getDistanceAtoB(vecFrom, vecTo);
        if (distance == 0.0) {
            distance = 0.1;
        }
        Vec3D offset = vecTo.copy();
        offset.subtract(vecFrom);
        return new Vec3D(offset.x / distance, offset.y / distance, offset.z / distance);
    }

    public static Vector3 getDirectionVec(Vector3 vecFrom, Vector3 vecTo) {
        double distance = Utils.getDistanceAtoB(vecFrom.x, vecFrom.y, vecFrom.z, vecTo.x, vecTo.y, vecTo.z);
        if (distance == 0.0) {
            distance = 0.1;
        }
        Vector3 offset = vecTo.copy();
        offset.subtract(vecFrom);
        return new Vector3(offset.x / distance, offset.y / distance, offset.z / distance);
    }

    public static Vec3D getCenter(BlockPos pos) {
        return new Vec3D(pos).add(0.5, 0.5, 0.5);
    }

    public static Vec3D getCenter(TileEntity tile) {
        return Vec3D.getCenter(tile.func_174877_v());
    }

    public double distXZ(Vec3D vec3D) {
        return Utils.getDistanceAtoB(this.x, this.z, vec3D.x, vec3D.z);
    }

    public double distance(Vec3D vec3D) {
        return Utils.getDistanceAtoB(this, vec3D);
    }

    public double distance(Entity entity) {
        return Utils.getDistanceAtoB(this, new Vec3D(entity));
    }

    public double distanceSq(Vec3D v) {
        return Utils.getDistanceSq(this.x, this.y, this.z, v.x, v.y, v.z);
    }

    public int floorX() {
        return MathHelper.func_76128_c((double)this.x);
    }

    public int floorY() {
        return MathHelper.func_76128_c((double)this.y);
    }

    public int floorZ() {
        return MathHelper.func_76128_c((double)this.z);
    }
}

