/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;

public class ManagedEnum<T extends Enum<T>>
extends AbstractManagedData<T> {
    private T value;
    public Map<Integer, T> indexToValue = new HashMap<Integer, T>();
    public Map<T, Integer> valueToIndex = new HashMap<T, Integer>();
    protected Function<T, T> validator = null;

    public ManagedEnum(String name, T defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        Enum[] v = (Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants();
        if (v.length > 255) {
            throw new RuntimeException("Max enum size supported by SyncableEnum is 255");
        }
        for (int i = 0; i < v.length; ++i) {
            this.indexToValue.put(i, v[i]);
            this.valueToIndex.put(v[i], i);
        }
    }

    public T set(T value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            T prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public T get() {
        return this.value;
    }

    public ManagedEnum<T> setValidator(Function<T, T> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = (Enum)this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeByte((int)this.valueToIndex.get(this.value).byteValue());
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = (Enum)this.indexToValue.get(MathHelper.clip((int)(input.readByte() & 0xFF), (int)0, (int)(this.indexToValue.size() - 1)));
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        compound.func_74774_a(this.name, this.valueToIndex.get(this.value).byteValue());
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = (Enum)this.indexToValue.get(MathHelper.clip((int)(compound.func_74771_c(this.name) & 0xFF), (int)0, (int)(this.indexToValue.size() - 1)));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

