/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class FilterGroup
extends FilterBase {
    protected Int2ObjectMap<FilterBase> subNodeMap = new Int2ObjectLinkedOpenHashMap();
    protected boolean andGroup = false;

    public FilterGroup(EntityFilter filter) {
        super(filter);
    }

    protected void addNode(FilterBase node) {
        if (EffectiveSide.get().isClient()) {
            throw new IllegalStateException("Filter notes can be edited client side but must be added and removed server side!");
        }
        if (this.getFilter().isFilterAllowed(node.getType())) {
            node.initNode(this);
            this.subNodeMap.put(node.nodeID, (Object)node);
            this.getFilter().filterChanged();
        }
    }

    protected void removeNode(FilterBase node) {
        if (EffectiveSide.get().isClient()) {
            throw new IllegalStateException("Filter notes can be edited client side but must be added and removed server side!");
        }
        if (node instanceof FilterGroup) {
            ((FilterGroup)node).getSubNodeMap().values().forEach(((FilterGroup)node)::removeNode);
        }
        this.subNodeMap.remove(node.nodeID);
        this.getFilter().dropNode(node);
        this.getFilter().filterChanged();
    }

    public void setAndGroup(boolean andGroup) {
        boolean prev = this.andGroup;
        this.andGroup = andGroup;
        this.getFilter().nodeModified(this);
        this.andGroup = prev;
    }

    public boolean isAndGroup() {
        return this.andGroup;
    }

    public Map<Integer, FilterBase> getSubNodeMap() {
        return this.subNodeMap;
    }

    @Override
    public boolean test(Entity entity) {
        if (this.andGroup) {
            return this.subNodeMap.isEmpty() || this.subNodeMap.values().stream().allMatch(node -> node.test(entity));
        }
        return this.subNodeMap.isEmpty() || this.subNodeMap.values().stream().anyMatch(node -> node.test(entity));
    }

    @Override
    public FilterType getType() {
        return FilterType.FILTER_GROUP;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("and_group", this.andGroup);
        if (!this.subNodeMap.isEmpty()) {
            ListNBT subs = new ListNBT();
            this.subNodeMap.values().forEach(node -> {
                CompoundNBT tag = node.serializeNBT();
                tag.func_74774_a("filter_type", (byte)node.getType().index);
                subs.add((Object)tag);
            });
            compound.func_218657_a("sub_nodes", (INBT)subs);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.andGroup = nbt.func_74767_n("and_group");
        this.subNodeMap.clear();
        if (nbt.func_74764_b("sub_nodes")) {
            ListNBT tagList = nbt.func_150295_c("sub_nodes", 10);
            for (INBT tag : tagList) {
                FilterType type = FilterType.filterTypeMap[((CompoundNBT)tag).func_74771_c("filter_type")];
                FilterBase node = type.createNode(this.getFilter());
                node.onLoaded(this);
                node.deserializeNBT((CompoundNBT)tag);
                if (node.nodeID == 0 && !(node instanceof EntityFilter)) {
                    LogHelperBC.warn("EntityFilter: Skipping broken filter node");
                    continue;
                }
                this.subNodeMap.put(node.nodeID, (Object)node);
            }
        }
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.andGroup);
        output.writeVarInt(this.subNodeMap.size());
        if (!this.subNodeMap.isEmpty()) {
            this.subNodeMap.values().forEach(node -> {
                output.writeByte(node.getType().index);
                node.serializeMCD(output);
            });
        }
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.andGroup = input.readBoolean();
        this.subNodeMap.clear();
        int subCount = input.readVarInt();
        for (int i = 0; i < subCount; ++i) {
            FilterType type = FilterType.filterTypeMap[input.readByte()];
            if (!this.getFilter().isFilterAllowed(type)) continue;
            FilterBase node = type.createNode(this.getFilter());
            node.onLoaded(this);
            node.deSerializeMCD(input);
            if (node.nodeID == 0 && !(node instanceof EntityFilter)) continue;
            this.subNodeMap.put(node.nodeID, (Object)node);
        }
    }
}

