/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.capability.OPWrappers;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtils {
    public static IOPStorage getStorage(TileEntity tile, Direction side) {
        if (tile.func_145831_w().field_72995_K) {
            LogHelperBC.bigDev("Attempt to do energy operation client side!", new Object[0]);
            return null;
        }
        return EnergyUtils.getStorageFromProvider((ICapabilityProvider)tile, side);
    }

    public static IOPStorage getStorage(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return EnergyUtils.getStorageFromProvider((ICapabilityProvider)stack, null);
        }
        return null;
    }

    public static IOPStorage getStorageFromProvider(ICapabilityProvider provider, Direction side) {
        LazyOptional op = provider.getCapability(CapabilityOP.OP, side);
        if (op.isPresent()) {
            return (IOPStorage)op.orElseThrow(ImpossibleException::new);
        }
        LazyOptional fe = provider.getCapability(CapabilityEnergy.ENERGY, side);
        if (fe.isPresent()) {
            return new OPWrappers.FE((IEnergyStorage)fe.orElseThrow(ImpossibleException::new));
        }
        return null;
    }

    public static long insertEnergy(TileEntity tile, long energy, Direction side, boolean simulate) {
        IOPStorage storage = EnergyUtils.getStorage(tile, side);
        if (storage != null && storage.canReceive()) {
            return storage.receiveOP(energy, simulate);
        }
        return 0L;
    }

    public static long insertEnergy(ItemStack stack, long energy, boolean simulate) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        if (storage != null && storage.canReceive()) {
            return storage.receiveOP(energy, simulate);
        }
        return 0L;
    }

    public static long insertEnergyIntoProvider(ICapabilityProvider provider, long energy, Direction side, boolean simulate) {
        IOPStorage storage = EnergyUtils.getStorageFromProvider(provider, side);
        if (storage != null && storage.canReceive()) {
            return storage.receiveOP(energy, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(TileEntity tile, long energy, Direction side, boolean simulate) {
        IOPStorage storage = EnergyUtils.getStorage(tile, side);
        if (storage != null && storage.canExtract()) {
            return storage.extractOP(energy, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(ItemStack stack, long energy, boolean simulate) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        if (storage != null && storage.canExtract()) {
            return storage.extractOP(energy, simulate);
        }
        return 0L;
    }

    public static long extractEnergyFromProvider(ICapabilityProvider provider, long energy, Direction side, boolean simulate) {
        IOPStorage storage = EnergyUtils.getStorageFromProvider(provider, side);
        if (storage != null && storage.canExtract()) {
            return storage.extractOP(energy, simulate);
        }
        return 0L;
    }

    public static long transferEnergy(IOPStorage source, IOPStorage target) {
        return target.receiveOP(source.extractOP(target.receiveOP(target.getMaxOPStored(), true), false), false);
    }

    public static long transferEnergy(TileEntity source, Direction sourceSide, IOPStorage target) {
        IOPStorage storage = EnergyUtils.getStorage(source, sourceSide);
        return storage == null ? 0L : EnergyUtils.transferEnergy(storage, target);
    }

    public static long transferEnergy(IOPStorage source, TileEntity target, Direction targetSide) {
        IOPStorage storage = EnergyUtils.getStorage(target, targetSide);
        return storage == null ? 0L : EnergyUtils.transferEnergy(source, storage);
    }

    public static long transferEnergy(ItemStack source, IOPStorage target) {
        IOPStorage storage = EnergyUtils.getStorage(source);
        return storage == null ? 0L : EnergyUtils.transferEnergy(storage, target);
    }

    public static long transferEnergy(IOPStorage source, ItemStack target) {
        IOPStorage storage = EnergyUtils.getStorage(target);
        return storage == null ? 0L : EnergyUtils.transferEnergy(source, storage);
    }

    public static long transferEnergy(ItemStack source, TileEntity target, Direction targetSide) {
        IOPStorage storage = EnergyUtils.getStorage(source);
        return storage == null ? 0L : EnergyUtils.transferEnergy(storage, target, targetSide);
    }

    public static long transferEnergy(TileEntity source, Direction sourceSide, ItemStack target) {
        IOPStorage storage = EnergyUtils.getStorage(target);
        return storage == null ? 0L : EnergyUtils.transferEnergy(source, sourceSide, storage);
    }

    public static long transferEnergy(TileEntity source, Direction sourceSide, TileEntity target, Direction targetSide) {
        IOPStorage sourceStorage = EnergyUtils.getStorage(source, sourceSide);
        if (sourceStorage == null) {
            return 0L;
        }
        IOPStorage targetStorage = EnergyUtils.getStorage(target, targetSide);
        return targetStorage == null ? 0L : EnergyUtils.transferEnergy(sourceStorage, targetStorage);
    }

    public static boolean canExtractEnergy(ItemStack stack) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        return storage != null && storage.canExtract();
    }

    public static boolean canReceiveEnergy(ItemStack stack) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        return storage != null && storage.canReceive();
    }

    public static boolean canExtractEnergy(TileEntity tile, Direction side) {
        IOPStorage storage = EnergyUtils.getStorage(tile, side);
        return storage != null && storage.canExtract();
    }

    public static boolean canReceiveEnergy(TileEntity tile, Direction side) {
        IOPStorage storage = EnergyUtils.getStorage(tile, side);
        return storage != null && storage.canReceive();
    }

    public static long getEnergyStored(TileEntity tile, Direction side) {
        IOPStorage storage = EnergyUtils.getStorage(tile, side);
        return storage == null ? 0L : storage.getOPStored();
    }

    public static long getMaxEnergyStored(TileEntity tile, Direction side) {
        IOPStorage storage = EnergyUtils.getStorage(tile, side);
        return storage == null ? 0L : storage.getMaxOPStored();
    }

    public static long getEnergyStored(ItemStack stack) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        return storage == null ? 0L : storage.getOPStored();
    }

    public static long getMaxEnergyStored(ItemStack stack) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        return storage == null ? 0L : storage.getMaxOPStored();
    }

    public static boolean isFullyOrInvalid(ItemStack stack) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        if (storage == null) {
            return true;
        }
        return storage.getOPStored() >= storage.getMaxOPStored();
    }

    public static boolean isEnergyItem(ItemStack stack) {
        return EnergyUtils.getStorage(stack) != null;
    }

    public static boolean isEmptyOrInvalid(ItemStack stack) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        if (storage == null) {
            return true;
        }
        return storage.getOPStored() == 0L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addEnergyInfo(ItemStack stack, List<ITextComponent> list) {
        IOPStorage storage = EnergyUtils.getStorage(stack);
        if (storage != null) {
            String energy = Utils.formatNumber(storage.getOPStored());
            String maxEnergy = Utils.formatNumber(storage.getMaxOPStored());
            String postFix = Screen.func_231173_s_() ? "(" + I18n.func_135052_a((String)"op.brandonscore.operational_potential", (Object[])new Object[0]) + ")" : I18n.func_135052_a((String)"op.brandonscore.op", (Object[])new Object[0]);
            list.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"op.brandonscore.charge", (Object[])new Object[0]) + ": " + energy + " / " + maxEnergy + " " + postFix).func_240699_a_(TextFormatting.GRAY));
        }
    }

    private static class ImpossibleException
    extends RuntimeException {
        public ImpossibleException() {
            super("This exception is impossible. If you're seeing this in a crash report then... shit...");
        }
    }
}

