/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.providers.IGasProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GasStack
extends ChemicalStack<Gas> {
    public static final GasStack EMPTY = new GasStack(MekanismAPI.EMPTY_GAS, 0L);

    public GasStack(IGasProvider gasProvider, long amount) {
        super(gasProvider.getChemical(), amount);
    }

    public GasStack(GasStack stack, long amount) {
        this((IGasProvider)stack.getType(), amount);
    }

    @Override
    protected IRegistryDelegate<Gas> getDelegate(Gas gas) {
        if (MekanismAPI.gasRegistry().getKey((IForgeRegistryEntry)gas) == null) {
            MekanismAPI.logger.fatal("Failed attempt to create a GasStack for an unregistered Gas {} (type {})", (Object)gas.getRegistryName(), (Object)gas.getClass().getName());
            throw new IllegalArgumentException("Cannot create a GasStack from an unregistered Gas");
        }
        return gas.delegate;
    }

    @Override
    protected Gas getEmptyChemical() {
        return MekanismAPI.EMPTY_GAS;
    }

    public static GasStack readFromNBT(@Nullable CompoundNBT nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        Gas type = Gas.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.func_74763_f("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new GasStack(type, amount);
    }

    public static GasStack readFromPacket(PacketBuffer buf) {
        Gas gas = (Gas)buf.readRegistryId();
        long amount = buf.func_179260_f();
        if (gas.isEmptyType()) {
            return EMPTY;
        }
        return new GasStack(gas, amount);
    }

    public GasStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new GasStack(this, this.getAmount());
    }
}

