/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalDissolutionRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, GasStack> {
    private final ItemStackIngredient itemInput;
    private final GasStackIngredient gasInput;
    private final BoxedChemicalStack output;

    public ChemicalDissolutionRecipe(ResourceLocation id, ItemStackIngredient itemInput, GasStackIngredient gasInput, ChemicalStack<?> output) {
        super(id);
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = BoxedChemicalStack.box(output.copy());
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public BoxedChemicalStack getOutput(ItemStack inputItem, GasStack inputGas) {
        return this.output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack, GasStack gasStack) {
        return this.itemInput.test(itemStack) && this.gasInput.test(gasStack);
    }

    public BoxedChemicalStack getOutputDefinition() {
        return this.output;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.itemInput.write(buffer);
        this.gasInput.write(buffer);
        buffer.func_179249_a((Enum)this.output.getChemicalType());
        this.output.getChemicalStack().writeToPacket(buffer);
    }
}

