/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.text.ITextComponent;

public class GuiGraph
extends GuiTexturedElement {
    private static final int TEXTURE_WIDTH = 3;
    private static final int TEXTURE_HEIGHT = 2;
    private final LongList graphData = new LongArrayList();
    private final GraphDataHandler dataHandler;
    private long currentScale = 10L;
    private boolean fixedScale = false;

    public GuiGraph(IGuiWrapper gui, int x, int y, int width, int height, GraphDataHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "graph.png"), gui, x, y, width, height);
        this.dataHandler = handler;
    }

    public void enableFixedScale(long scale) {
        this.fixedScale = true;
        this.currentScale = scale;
    }

    public void setMinScale(long minScale) {
        this.currentScale = minScale;
    }

    public void addData(long data) {
        if (this.graphData.size() == this.field_230688_j_ - 2) {
            this.graphData.removeLong(0);
        }
        this.graphData.add(data);
        if (!this.fixedScale) {
            LongListIterator longListIterator = this.graphData.iterator();
            while (longListIterator.hasNext()) {
                long i = (Long)longListIterator.next();
                if (i <= this.currentScale) continue;
                this.currentScale = i;
            }
        }
    }

    @Override
    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(matrix, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        GuiGraph.minecraft.field_71446_o.func_110577_a(this.getResource());
        int size = this.graphData.size();
        int x = this.field_230690_l_ + 1;
        int y = this.field_230691_m_ + 1;
        int height = this.field_230689_k_ - 2;
        for (int i = 0; i < size; ++i) {
            long data = Math.min(this.currentScale, this.graphData.getLong(i));
            int relativeHeight = (int)((double)(data * (long)height) / (double)this.currentScale);
            GuiGraph.func_238463_a_((MatrixStack)matrix, (int)(x + i), (int)(y + height - relativeHeight), (float)0.0f, (float)0.0f, (int)1, (int)1, (int)3, (int)2);
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * (float)i / (float)size));
            GuiGraph.func_238463_a_((MatrixStack)matrix, (int)(x + i), (int)(y + height - relativeHeight), (float)1.0f, (float)0.0f, (int)1, (int)relativeHeight, (int)3, (int)2);
            int hoverIndex = mouseX - this.getButtonX();
            if (hoverIndex == i && mouseY >= this.getButtonY() && mouseY < this.getButtonY() + height) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GuiGraph.func_238463_a_((MatrixStack)matrix, (int)(x + i), (int)y, (float)2.0f, (float)0.0f, (int)1, (int)height, (int)3, (int)2);
                MekanismRenderer.resetColor();
                GuiGraph.func_238463_a_((MatrixStack)matrix, (int)(x + i), (int)(y + height - relativeHeight), (float)0.0f, (float)1.0f, (int)1, (int)1, (int)3, (int)2);
            }
            MekanismRenderer.resetColor();
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
        }
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        int hoverIndex = mouseX - this.relativeX;
        if (hoverIndex >= 0 && hoverIndex < this.graphData.size()) {
            this.displayTooltip(matrix, this.dataHandler.getDataDisplay(this.graphData.getLong(hoverIndex)), mouseX, mouseY);
        }
    }

    public static interface GraphDataHandler {
        public ITextComponent getDataDisplay(long var1);
    }
}

