/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.to_server.PacketDropperUse;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiTankBar<STACK>
extends GuiBar<TankInfoProvider<STACK>>
implements IJEIIngredientHelper {
    public GuiTankBar(IGuiWrapper gui, TankInfoProvider<STACK> infoProvider, int x, int y, int width, int height, boolean horizontal) {
        super(AtlasTexture.field_110575_b, gui, infoProvider, x, y, width, height, horizontal);
    }

    protected abstract boolean isEmpty(STACK var1);

    @Nullable
    protected abstract PacketDropperUse.TankType getType(STACK var1);

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        Object stored = ((TankInfoProvider)this.getHandler()).getStack();
        if (this.isEmpty(stored)) {
            super.func_230443_a_(matrix, mouseX, mouseY);
        } else {
            this.displayTooltips(matrix, this.getTooltip(stored), mouseX, mouseY);
        }
    }

    protected List<ITextComponent> getTooltip(STACK stack) {
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        ITextComponent tooltip = ((TankInfoProvider)this.getHandler()).getTooltip();
        if (tooltip != null) {
            tooltips.add(tooltip);
        }
        return tooltips;
    }

    protected abstract void applyRenderColor(STACK var1);

    protected abstract TextureAtlasSprite getIcon(STACK var1);

    @Override
    protected void renderBarOverlay(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel) {
        int displayInt;
        Object stored = ((TankInfoProvider)this.getHandler()).getStack();
        if (!this.isEmpty(stored) && (displayInt = (int)(handlerLevel * (double)((this.horizontal ? this.field_230688_j_ : this.field_230689_k_) - 2))) > 0) {
            this.applyRenderColor(stored);
            TextureAtlasSprite icon = this.getIcon(stored);
            if (this.horizontal) {
                this.drawTiledSprite(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230689_k_ - 2, displayInt, this.field_230689_k_ - 2, icon, GuiUtils.TilingDirection.DOWN_RIGHT);
            } else {
                this.drawTiledSprite(matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230689_k_ - 2, this.field_230688_j_ - 2, displayInt, icon, GuiUtils.TilingDirection.DOWN_RIGHT);
            }
            MekanismRenderer.resetColor();
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            PacketDropperUse.TankType tankType;
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
            if (this.gui() instanceof GuiMekanismTile && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper && (tankType = this.getType(((TankInfoProvider)this.getHandler()).getStack())) != null) {
                int index = ((TankInfoProvider)this.getHandler()).getTankIndex();
                if (index != -1) {
                    PacketDropperUse.DropperAction action = button == 0 ? (Screen.func_231173_s_() ? PacketDropperUse.DropperAction.DUMP_TANK : PacketDropperUse.DropperAction.FILL_DROPPER) : PacketDropperUse.DropperAction.DRAIN_DROPPER;
                    Mekanism.packetHandler.sendToServer(new PacketDropperUse(((GuiMekanismTile)this.gui()).getTileEntity().func_174877_v(), action, tankType, index));
                }
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public Object getIngredient() {
        Object stack = ((TankInfoProvider)this.getHandler()).getStack();
        return this.isEmpty(stack) ? null : stack;
    }

    public static interface TankInfoProvider<STACK>
    extends GuiBar.IBarInfoHandler {
        @Nonnull
        public STACK getStack();

        public int getTankIndex();
    }
}

