/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.StackUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiQIORedstoneAdapter
extends GuiMekanismTile<TileEntityQIORedstoneAdapter, MekanismTileContainer<TileEntityQIORedstoneAdapter>> {
    private GuiTextField text;

    public GuiQIORedstoneAdapter(MekanismTileContainer<TileEntityQIORedstoneAdapter> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.field_147000_g += 16;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        ((GuiSlot)this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, 7, 30).setRenderHover(true))).setGhostHandler(ingredient -> {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (TileEntity)this.tile, StackUtils.size((ItemStack)ingredient, 1)));
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
        });
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 7, 16, this.field_146999_f - 15, 12, () -> {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            QIOFrequency freq = ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency();
            if (freq == null) {
                list.add(MekanismLang.NO_FREQUENCY.translate(new Object[0]));
            } else {
                list.add(MekanismLang.FREQUENCY.translate(freq.getKey()));
            }
            return list;
        }).tooltip(() -> {
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            QIOFrequency freq = ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency();
            if (freq != null) {
                list.add(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity())));
                list.add(MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity())));
            }
            return list;
        }));
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 27, 30, this.field_146999_f - 27 - 8, 54, () -> {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add((TranslationTextComponent)(!((TileEntityQIORedstoneAdapter)this.tile).getItemType().func_190926_b() ? ((TileEntityQIORedstoneAdapter)this.tile).getItemType().getStack().func_200301_q() : MekanismLang.QIO_ITEM_TYPE_UNDEFINED.translate(new Object[0])));
            list.add(MekanismLang.QIO_TRIGGER_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getCount())));
            if (!((TileEntityQIORedstoneAdapter)this.tile).getItemType().func_190926_b() && ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency() != null) {
                list.add(MekanismLang.QIO_STORED_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getStoredCount())));
            }
            return list;
        }).clearFormat());
        this.text = (GuiTextField)this.func_230480_a_(new GuiTextField(this, 29, 70, this.field_146999_f - 39, 12));
        this.text.setMaxStringLength(10);
        this.text.setInputValidator(InputValidator.DIGIT);
        this.text.func_230996_d_(true);
        this.text.configureDigitalInput(this::setCount);
    }

    private void setCount() {
        if (!this.text.getText().isEmpty()) {
            long count = Long.parseLong(this.text.getText());
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.QIO_REDSTONE_ADAPTER_COUNT, (TileEntity)this.tile, (int)Math.min(count, Integer.MAX_VALUE)));
            this.text.setText("");
        }
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        if (((TileEntityQIORedstoneAdapter)this.tile).getItemType() != null) {
            this.renderItem(matrix, ((TileEntityQIORedstoneAdapter)this.tile).getItemType(), 8, 31);
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        super.func_231044_a_(mouseX, mouseY, button);
        if (button == 0) {
            double xAxis = mouseX - (double)this.field_147003_i;
            double yAxis = mouseY - (double)this.field_147009_r;
            if (xAxis >= 8.0 && xAxis < 24.0 && yAxis >= 31.0 && yAxis < 47.0) {
                ItemStack stack = this.getMinecraft().field_71439_g.field_71071_by.func_70445_o();
                if (!stack.func_190926_b() && !GuiQIORedstoneAdapter.func_231173_s_()) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (TileEntity)this.tile, StackUtils.size(stack, 1)));
                } else if (stack.func_190926_b() && GuiQIORedstoneAdapter.func_231173_s_()) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (TileEntity)this.tile, ItemStack.field_190927_a));
                }
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
            }
        }
        return true;
    }
}

