/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IItemProvider;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.ChemicalStackRenderer;
import mekanism.client.jei.NOOPDrawable;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseRecipeCategory<RECIPE>
implements IRecipeCategory<RECIPE>,
IGuiWrapper {
    private static final IProgressInfoHandler CONSTANT_PROGRESS = () -> 1.0;
    protected static final GuiBar.IBarInfoHandler FULL_BAR = () -> 1.0;
    private final Set<GuiTexturedElement> guiElements = new ObjectOpenHashSet();
    private final ITextComponent component;
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final ResourceLocation id;
    private final IDrawable icon;
    private final int xOffset;
    private final int yOffset;
    @Nullable
    private Map<GaugeOverlay, IDrawable> overlayLookup;
    @Nullable
    private ITickTimer timer;

    protected static IDrawable createIcon(IGuiHelper helper, ResourceLocation iconRL) {
        return helper.drawableBuilder(iconRL, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    protected static IDrawable createIcon(IGuiHelper helper, IItemProvider provider) {
        return helper.createDrawableIngredient((Object)provider.getItemStack());
    }

    protected BaseRecipeCategory(IGuiHelper helper, IItemProvider provider, int xOffset, int yOffset, int width, int height) {
        this(helper, provider.getRegistryName(), provider.getTextComponent(), BaseRecipeCategory.createIcon(helper, provider), xOffset, yOffset, width, height);
    }

    protected BaseRecipeCategory(IGuiHelper helper, ResourceLocation id, ITextComponent component, IDrawable icon, int xOffset, int yOffset, int width, int height) {
        this.id = id;
        this.component = component;
        this.guiHelper = helper;
        this.icon = icon;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.background = new NOOPDrawable(width, height);
    }

    protected <ELEMENT extends GuiTexturedElement> ELEMENT addElement(ELEMENT element) {
        this.guiElements.add(element);
        return element;
    }

    protected GuiSlot addSlot(SlotType type, int x, int y) {
        return this.addElement(new GuiSlot(type, this, x - 1, y - 1));
    }

    protected GuiProgress addSimpleProgress(ProgressType type, int x, int y) {
        return this.addElement(new GuiProgress(this.getSimpleProgressTimer(), type, (IGuiWrapper)this, x, y));
    }

    protected GuiProgress addConstantProgress(ProgressType type, int x, int y) {
        return this.addElement(new GuiProgress(CONSTANT_PROGRESS, type, (IGuiWrapper)this, x, y));
    }

    @Override
    public int getLeft() {
        return -this.xOffset;
    }

    @Override
    public int getTop() {
        return -this.yOffset;
    }

    @Override
    public int getWidth() {
        return this.background.getWidth();
    }

    @Override
    public int getHeight() {
        return this.background.getHeight();
    }

    public ResourceLocation getUid() {
        return this.id;
    }

    @Deprecated
    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public ITextComponent getTitleAsTextComponent() {
        return this.component;
    }

    public void draw(RECIPE recipe, MatrixStack matrix, double mouseX, double mouseY) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        this.guiElements.forEach(e -> e.func_230430_a_(matrix, x, y, 0.0f));
        this.guiElements.forEach(e -> e.onDrawBackground(matrix, x, y, 0.0f));
        int zOffset = 200;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)(-this.xOffset), (double)(-this.yOffset), 0.0);
        for (GuiTexturedElement element : this.guiElements) {
            matrix.func_227860_a_();
            element.onRenderForeground(matrix, x, y, zOffset, zOffset);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    @Override
    public FontRenderer getFont() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected IProgressInfoHandler getSimpleProgressTimer() {
        if (this.timer == null) {
            this.timer = this.guiHelper.createTickTimer(20, 20, false);
        }
        return () -> (double)this.timer.getValue() / 20.0;
    }

    protected GuiBar.IBarInfoHandler getBarProgressTimer() {
        if (this.timer == null) {
            this.timer = this.guiHelper.createTickTimer(20, 20, false);
        }
        return new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.PROGRESS.translate(TextUtils.getPercent(this.getLevel()));
            }

            @Override
            public double getLevel() {
                return (double)BaseRecipeCategory.this.timer.getValue() / 20.0;
            }
        };
    }

    private IDrawable getOverlay(GuiGauge<?> gauge) {
        if (this.overlayLookup == null) {
            this.overlayLookup = new EnumMap<GaugeOverlay, IDrawable>(GaugeOverlay.class);
        }
        return this.overlayLookup.computeIfAbsent(gauge.getGaugeOverlay(), overlay -> this.createDrawable(this.guiHelper, (GaugeOverlay)((Object)overlay)));
    }

    private IDrawable createDrawable(IGuiHelper helper, GaugeOverlay gaugeOverlay) {
        return helper.drawableBuilder(gaugeOverlay.getBarOverlay(), 0, 0, gaugeOverlay.getWidth(), gaugeOverlay.getHeight()).setTextureSize(gaugeOverlay.getWidth(), gaugeOverlay.getHeight()).build();
    }

    protected void initItem(IGuiIngredientGroup<ItemStack> group, int slotIndex, boolean input, GuiSlot slot, List<ItemStack> stacks) {
        this.initItem(group, slotIndex, input, slot.getRelativeX(), slot.getRelativeY(), stacks);
    }

    protected void initItem(IGuiIngredientGroup<ItemStack> group, int slotIndex, boolean input, int relativeX, int relativeY, List<ItemStack> stacks) {
        group.init(slotIndex, input, relativeX - this.xOffset, relativeY - this.yOffset);
        group.set(slotIndex, stacks);
    }

    protected void initFluid(IGuiFluidStackGroup group, int tankIndex, boolean input, GuiGauge<?> gauge, List<FluidStack> stacks) {
        int x = gauge.getRelativeX() + 1 - this.xOffset;
        int y = gauge.getRelativeY() + 1 - this.yOffset;
        int width = gauge.func_230998_h_() - 2;
        int height = gauge.func_238483_d_() - 2;
        int max = stacks.stream().mapToInt(FluidStack::getAmount).filter(stackSize -> stackSize >= 0).max().orElse(0);
        group.init(tankIndex, input, x, y, width, height, max, false, this.getOverlay(gauge));
        group.set(tankIndex, stacks);
    }

    protected <STACK extends ChemicalStack<?>> void initChemical(IGuiIngredientGroup<STACK> group, int tankIndex, boolean input, GuiBar<?> bar, List<STACK> stacks) {
        this.initChemical(group, tankIndex, input, bar, stacks, ChemicalStackRenderer::new);
    }

    protected <STACK extends ChemicalStack<?>> void initChemical(IGuiIngredientGroup<STACK> group, int tankIndex, boolean input, GuiGauge<?> gauge, List<STACK> stacks) {
        this.initChemical(group, tankIndex, input, gauge, stacks, (max, width, height) -> new ChemicalStackRenderer(max, width, height, this.getOverlay(gauge)));
    }

    private <STACK extends ChemicalStack<?>> void initChemical(IGuiIngredientGroup<@NonNull STACK> group, int tankIndex, boolean input, GuiElement element, List<STACK> stacks, ChemicalStackRendererCreator<STACK> rendererCreator) {
        int x = element.getRelativeX() + 1 - this.xOffset;
        int y = element.getRelativeY() + 1 - this.yOffset;
        int width = element.func_230998_h_() - 2;
        int height = element.func_238483_d_() - 2;
        long max = stacks.stream().mapToLong(ChemicalStack::getAmount).filter(stackSize -> stackSize >= 0L).max().orElse(0L);
        group.init(tankIndex, input, rendererCreator.create(max, width, height), x, y, width, height, 0, 0);
        group.set(tankIndex, stacks);
    }

    @FunctionalInterface
    private static interface ChemicalStackRendererCreator<STACK extends ChemicalStack<?>> {
        public ChemicalStackRenderer<STACK> create(long var1, int var3, int var4);
    }
}

