/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.JEIColorDetails;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.config.DataType;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;

public class PigmentMixerRecipeCategory
extends BaseRecipeCategory<PigmentMixingRecipe> {
    private final Map<PigmentMixingRecipe, IGuiIngredientGroup<PigmentStack>> ingredients = new WeakHashMap<PigmentMixingRecipe, IGuiIngredientGroup<PigmentStack>>();
    private final PigmentColorDetails leftColorDetails;
    private final PigmentColorDetails rightColorDetails;
    private final GuiGauge<?> leftInputGauge = this.addElement(GuiPigmentGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT_1), this, 25, 13));
    private final GuiGauge<?> rightInputGauge;
    private final GuiGauge<?> outputGauge = this.addElement(GuiPigmentGauge.getDummy(GaugeType.STANDARD.with(DataType.OUTPUT), this, 79, 4));

    public PigmentMixerRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.PIGMENT_MIXER, 3, 3, 170, 80);
        this.rightInputGauge = this.addElement(GuiPigmentGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT_2), this, 133, 13));
        this.addSlot(SlotType.INPUT, 6, 56).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.INPUT_2, 154, 56).with(SlotOverlay.MINUS);
        this.addSlot(SlotType.OUTPUT, 80, 65).with(SlotOverlay.PLUS);
        this.addSlot(SlotType.POWER, 154, 14).with(SlotOverlay.POWER);
        this.leftColorDetails = new PigmentColorDetails();
        this.addConstantProgress(ProgressType.SMALL_RIGHT, 47, 39).colored(this.leftColorDetails);
        this.rightColorDetails = new PigmentColorDetails();
        this.addConstantProgress(ProgressType.SMALL_LEFT, 101, 39).colored(this.rightColorDetails);
        this.addElement(new GuiHorizontalPowerBar((IGuiWrapper)this, FULL_BAR, 115, 75));
    }

    public Class<? extends PigmentMixingRecipe> getRecipeClass() {
        return PigmentMixingRecipe.class;
    }

    @Override
    public void draw(PigmentMixingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IGuiIngredientGroup<PigmentStack> group = this.ingredients.get(recipe);
        if (group != null) {
            Map guiIngredients = group.getGuiIngredients();
            this.leftColorDetails.ingredient = (IGuiIngredient)guiIngredients.get(0);
            this.rightColorDetails.ingredient = (IGuiIngredient)guiIngredients.get(1);
            this.leftColorDetails.outputIngredient = (IGuiIngredient)guiIngredients.get(2);
            this.rightColorDetails.outputIngredient = this.leftColorDetails.outputIngredient;
        }
        super.draw(recipe, matrixStack, mouseX, mouseY);
        this.leftColorDetails.ingredient = null;
        this.rightColorDetails.outputIngredient = null;
    }

    public void setIngredients(PigmentMixingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(MekanismJEI.TYPE_PIGMENT, Arrays.asList(((PigmentStackIngredient)recipe.getLeftInput()).getRepresentations(), ((PigmentStackIngredient)recipe.getRightInput()).getRepresentations()));
        ingredients.setOutputLists(MekanismJEI.TYPE_PIGMENT, Collections.singletonList(recipe.getOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PigmentMixingRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup pigmentStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_PIGMENT);
        this.initChemical(pigmentStacks, 0, true, this.leftInputGauge, ((PigmentStackIngredient)recipe.getLeftInput()).getRepresentations());
        this.initChemical(pigmentStacks, 1, true, this.rightInputGauge, ((PigmentStackIngredient)recipe.getRightInput()).getRepresentations());
        this.initChemical(pigmentStacks, 2, false, this.outputGauge, recipe.getOutputDefinition());
        this.ingredients.put(recipe, (IGuiIngredientGroup<PigmentStack>)pigmentStacks);
    }

    private static class PigmentColorDetails
    extends JEIColorDetails<Pigment, PigmentStack> {
        @Nullable
        private IGuiIngredient<PigmentStack> ingredient;
        @Nullable
        private IGuiIngredient<PigmentStack> outputIngredient;

        private PigmentColorDetails() {
            super(PigmentStack.EMPTY);
        }

        @Override
        public int getColorFrom() {
            return this.getColor(this.ingredient);
        }

        @Override
        public int getColorTo() {
            return this.getColor(this.outputIngredient);
        }
    }
}

