/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.Mekanism;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBounding
extends Block
implements IHasTileEntity<TileEntityBoundingBlock>,
IStateFluidLoggable {
    private final boolean advanced;

    @Nullable
    public static BlockPos getMainBlockPos(IBlockReader world, BlockPos thisPos) {
        TileEntityBoundingBlock te = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, world, thisPos);
        if (te != null && te.receivedCoords && !thisPos.equals((Object)te.getMainPos())) {
            return te.getMainPos();
        }
        return null;
    }

    public BlockBounding(boolean advanced) {
        super(BlockStateHelper.applyLightLevelAdjustments(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.5f, 4.8f).func_235861_h_().func_208770_d()));
        this.advanced = advanced;
        this.func_180632_j(BlockStateHelper.getDefaultState((BlockState)this.field_176227_L.func_177621_b()));
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        BlockStateHelper.fillBlockStateContainer(this, builder);
    }

    @Nonnull
    @Deprecated
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        return BlockStateHelper.getStateForPlacement(this, super.func_196258_a(context), context);
    }

    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
        if (mainPos == null) {
            return ActionResultType.FAIL;
        }
        BlockState mainState = world.func_180495_p(mainPos);
        return mainState.func_177230_c().func_225533_a_(mainState, world, mainPos, player, hand, hit);
    }

    @Deprecated
    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            BlockState mainState;
            BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
            if (mainPos != null && !(mainState = world.func_180495_p(mainPos)).isAir((IBlockReader)world, mainPos)) {
                world.func_217377_a(mainPos, false);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return ItemStack.field_190927_a;
        }
        BlockState mainState = world.func_180495_p(mainPos);
        return mainState.func_177230_c().getPickBlock(mainState, target, world, mainPos, player);
    }

    public boolean removedByPlayer(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, boolean willHarvest, FluidState fluidState) {
        BlockState mainState;
        if (willHarvest) {
            return true;
        }
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
        if (mainPos != null && !(mainState = world.func_180495_p(mainPos)).isAir((IBlockReader)world, mainPos)) {
            mainState.removedByPlayer(world, mainPos, player, false, mainState.func_204520_s());
        }
        return super.removedByPlayer(state, world, pos, player, false, fluidState);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        BlockState mainState;
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
        if (mainPos != null && !(mainState = world.func_180495_p(mainPos)).isAir((IBlockReader)world, mainPos)) {
            LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)mainPos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, mainState.hasTileEntity() ? WorldUtils.getTileEntity((IBlockReader)world, mainPos) : null).func_216021_b(LootParameters.field_216281_a, (Object)explosion.getExploder());
            if (explosion.field_222260_b == Explosion.Mode.DESTROY) {
                lootContextBuilder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(explosion.field_77280_f));
            }
            mainState.func_215693_a(lootContextBuilder).forEach(stack -> Block.func_180635_a((World)world, (BlockPos)mainPos, (ItemStack)stack));
            mainState.onBlockExploded(world, mainPos, explosion);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_180657_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, TileEntity te, @Nonnull ItemStack stack) {
        BlockPos mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos);
        if (mainPos != null) {
            BlockState mainState = world.func_180495_p(mainPos);
            mainState.func_177230_c().func_180657_a(world, player, mainPos, mainState, WorldUtils.getTileEntity((IBlockReader)world, mainPos), stack);
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
        world.func_217377_a(pos, false);
    }

    @Deprecated
    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        BlockPos mainPos;
        TileEntityBoundingBlock tile;
        if (!world.field_72995_K && (tile = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, pos)) != null) {
            tile.onNeighborChange(neighborBlock, neighborPos);
        }
        if ((mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos)) != null) {
            world.func_180495_p(mainPos).func_215697_a(world, mainPos, neighborBlock, neighborPos, isMoving);
        }
    }

    @Deprecated
    public boolean func_149740_M(@Nonnull BlockState blockState) {
        return true;
    }

    @Deprecated
    public int func_180641_l(@Nonnull BlockState blockState, @Nonnull World world, @Nonnull BlockPos pos) {
        TileEntityBoundingBlock tile;
        if (!world.field_72995_K && (tile = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)world, pos)) != null) {
            return tile.getComparatorSignal();
        }
        return 0;
    }

    @Deprecated
    public float func_180647_a(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return super.func_180647_a(state, player, world, pos);
        }
        return world.func_180495_p(mainPos).func_185903_a(player, world, mainPos);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return super.getExplosionResistance(state, world, pos, explosion);
        }
        return world.func_180495_p(mainPos).getExplosionResistance(world, mainPos, explosion);
    }

    @Nonnull
    @Deprecated
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return this.getTileType().func_200968_a();
    }

    @Override
    public TileEntityType<TileEntityBoundingBlock> getTileType() {
        if (this.advanced) {
            return MekanismTileEntityTypes.ADVANCED_BOUNDING_BLOCK.getTileEntityType();
        }
        return MekanismTileEntityTypes.BOUNDING_BLOCK.getTileEntityType();
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        BlockState mainState;
        BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
        if (mainPos == null) {
            return VoxelShapes.func_197880_a();
        }
        try {
            mainState = world.func_180495_p(mainPos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (world instanceof ChunkRenderCache) {
                world = ((ChunkRenderCache)world).field_212408_i;
                mainState = world.func_180495_p(mainPos);
            }
            Mekanism.logger.error("Error getting bounding block shape, for position {}, with main position {}. World of type {}", (Object)pos, (Object)mainPos, (Object)world.getClass().getName());
            return VoxelShapes.func_197880_a();
        }
        VoxelShape shape = mainState.func_215700_a(world, mainPos, context);
        BlockPos offset = pos.func_177973_b((Vector3i)mainPos);
        return shape.func_197751_a((double)(-offset.func_177958_n()), (double)(-offset.func_177956_o()), (double)(-offset.func_177952_p()));
    }

    @Nonnull
    @Deprecated
    public FluidState func_204507_t(@Nonnull BlockState state) {
        return this.getFluid(state);
    }

    @Nonnull
    @Deprecated
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        this.updateFluids(state, world, currentPos);
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Deprecated
    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull PathType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockState mainState;
        BlockRayTraceResult blockTarget;
        BlockPos pos;
        BlockPos mainPos;
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK && target instanceof BlockRayTraceResult && (mainPos = BlockBounding.getMainBlockPos((IBlockReader)world, pos = (blockTarget = (BlockRayTraceResult)target).func_216350_a())) != null && !(mainState = world.func_180495_p(mainPos)).isAir((IBlockReader)world, mainPos)) {
            AxisAlignedBB axisalignedbb = state.func_196954_c((IBlockReader)world, pos).func_197752_a();
            double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
            double y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
            double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
            Direction side = blockTarget.func_216354_b();
            if (side == Direction.DOWN) {
                y = (double)pos.func_177956_o() + axisalignedbb.field_72338_b - 0.1;
            } else if (side == Direction.UP) {
                y = (double)pos.func_177956_o() + axisalignedbb.field_72337_e + 0.1;
            } else if (side == Direction.NORTH) {
                z = (double)pos.func_177952_p() + axisalignedbb.field_72339_c - 0.1;
            } else if (side == Direction.SOUTH) {
                z = (double)pos.func_177952_p() + axisalignedbb.field_72334_f + 0.1;
            } else if (side == Direction.WEST) {
                x = (double)pos.func_177958_n() + axisalignedbb.field_72340_a - 0.1;
            } else if (side == Direction.EAST) {
                x = (double)pos.func_177958_n() + axisalignedbb.field_72336_d + 0.1;
            }
            manager.func_78873_a(new DiggingParticle((ClientWorld)world, x, y, z, 0.0, 0.0, 0.0, mainState).func_174846_a(mainPos).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }
}

