/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.Contract;

public class AttributeStateFacing
implements AttributeState {
    private final DirectionProperty facingProperty;
    private final FacePlacementType placementType;
    private final boolean canRotate;

    public AttributeStateFacing() {
        this(true);
    }

    public AttributeStateFacing(boolean canRotate) {
        this(BlockStateProperties.field_208157_J, canRotate);
    }

    public AttributeStateFacing(DirectionProperty facingProperty) {
        this(facingProperty, true);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, boolean canRotate) {
        this(facingProperty, FacePlacementType.PLAYER_LOCATION, canRotate);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType) {
        this(facingProperty, placementType, true);
    }

    public AttributeStateFacing(DirectionProperty facingProperty, FacePlacementType placementType, boolean canRotate) {
        this.facingProperty = facingProperty;
        this.placementType = placementType;
        this.canRotate = canRotate;
    }

    public boolean canRotate() {
        return this.canRotate;
    }

    public Direction getDirection(BlockState state) {
        return (Direction)state.func_177229_b((Property)this.getFacingProperty());
    }

    public BlockState setDirection(@Nonnull BlockState state, Direction newDirection) {
        return this.supportsDirection(newDirection) ? (BlockState)state.func_206870_a((Property)this.getFacingProperty(), (Comparable)newDirection) : state;
    }

    @Nonnull
    public DirectionProperty getFacingProperty() {
        return this.facingProperty;
    }

    @Nonnull
    public FacePlacementType getPlacementType() {
        return this.placementType;
    }

    public Collection<Direction> getSupportedDirections() {
        return this.getFacingProperty().func_177700_c();
    }

    public boolean supportsDirection(Direction direction) {
        return this.getSupportedDirections().contains(direction);
    }

    @Override
    public void fillBlockStateContainer(Block block, List<Property<?>> properties) {
        properties.add((Property<?>)this.getFacingProperty());
    }

    @Override
    public BlockState copyStateData(BlockState oldState, BlockState newState) {
        if (Attribute.has(newState, AttributeStateFacing.class)) {
            DirectionProperty oldFacingProperty = Attribute.get(oldState, AttributeStateFacing.class).getFacingProperty();
            newState = (BlockState)newState.func_206870_a((Property)Attribute.get(newState, AttributeStateFacing.class).getFacingProperty(), oldState.func_177229_b((Property)oldFacingProperty));
        }
        return newState;
    }

    @Override
    @Contract(value="_, null, _, _, _, _ -> null")
    public BlockState getStateForPlacement(Block block, @Nullable BlockState state, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nullable PlayerEntity player, @Nonnull Direction face) {
        if (state == null) {
            return null;
        }
        AttributeStateFacing blockFacing = Attribute.get(block, AttributeStateFacing.class);
        Direction newDirection = Direction.SOUTH;
        if (blockFacing.getPlacementType() == FacePlacementType.PLAYER_LOCATION) {
            if (blockFacing.supportsDirection(Direction.DOWN) && blockFacing.supportsDirection(Direction.UP)) {
                float rotationPitch = player == null ? 0.0f : player.field_70125_A;
                int height = Math.round(rotationPitch);
                if (height >= 65) {
                    newDirection = Direction.UP;
                } else if (height <= -65) {
                    newDirection = Direction.DOWN;
                }
            }
            if (newDirection != Direction.DOWN && newDirection != Direction.UP) {
                float placementYaw = player == null ? 0.0f : player.field_70177_z;
                int side = MathHelper.func_76128_c((double)((double)(placementYaw * 4.0f / 360.0f) + 0.5)) & 3;
                switch (side) {
                    case 0: {
                        newDirection = Direction.NORTH;
                        break;
                    }
                    case 1: {
                        newDirection = Direction.EAST;
                        break;
                    }
                    case 2: {
                        newDirection = Direction.SOUTH;
                        break;
                    }
                    case 3: {
                        newDirection = Direction.WEST;
                    }
                }
            }
        } else {
            newDirection = blockFacing.supportsDirection(face) ? face : Direction.NORTH;
        }
        state = blockFacing.setDirection(state, newDirection);
        return state;
    }

    public static BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return AttributeStateFacing.rotate(state, rotation);
    }

    public static BlockState rotate(BlockState state, Rotation rotation) {
        AttributeStateFacing blockFacing;
        Block block = state.func_177230_c();
        if (Attribute.has(block, AttributeStateFacing.class) && (blockFacing = Attribute.get(block, AttributeStateFacing.class)).canRotate()) {
            return AttributeStateFacing.rotate(blockFacing, blockFacing.getFacingProperty(), state, rotation);
        }
        return state;
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        AttributeStateFacing blockFacing;
        Block block = state.func_177230_c();
        if (Attribute.has(block, AttributeStateFacing.class) && (blockFacing = Attribute.get(block, AttributeStateFacing.class)).canRotate()) {
            DirectionProperty property = blockFacing.getFacingProperty();
            return AttributeStateFacing.rotate(blockFacing, property, state, mirror.func_185800_a((Direction)state.func_177229_b((Property)property)));
        }
        return state;
    }

    private static BlockState rotate(AttributeStateFacing blockFacing, DirectionProperty property, BlockState state, Rotation rotation) {
        return blockFacing.setDirection(state, rotation.func_185831_a((Direction)state.func_177229_b((Property)property)));
    }

    public static enum FacePlacementType {
        PLAYER_LOCATION,
        SELECTED_FACE;

    }
}

