/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.resolver;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasicCapabilityResolver
implements ICapabilityResolver {
    private final List<Capability<?>> supportedCapability;
    private final NonNullSupplier<?> supplier;
    private LazyOptional<?> cachedCapability;

    public static <T> BasicCapabilityResolver create(Capability<T> supportedCapability, NonNullSupplier<T> supplier) {
        return new BasicCapabilityResolver(supportedCapability, supplier);
    }

    public static <T> BasicCapabilityResolver persistent(Capability<T> supportedCapability, NonNullSupplier<T> supplier) {
        return BasicCapabilityResolver.create(supportedCapability, supplier instanceof NonNullLazy ? supplier : NonNullLazy.of(supplier));
    }

    public static <T> BasicCapabilityResolver constant(Capability<T> supportedCapability, T value) {
        return BasicCapabilityResolver.create(supportedCapability, () -> value);
    }

    protected <T> BasicCapabilityResolver(Capability<T> supportedCapability, NonNullSupplier<T> supplier) {
        this.supportedCapability = Collections.singletonList(supportedCapability);
        this.supplier = supplier;
    }

    @Override
    public List<Capability<?>> getSupportedCapabilities() {
        return this.supportedCapability;
    }

    @Override
    public <T> LazyOptional<T> resolve(Capability<T> capability, @Nullable Direction side) {
        if (this.cachedCapability == null || !this.cachedCapability.isPresent()) {
            this.cachedCapability = LazyOptional.of(this.supplier);
        }
        return this.cachedCapability.cast();
    }

    @Override
    public void invalidate(Capability<?> capability, @Nullable Direction side) {
        this.invalidateAll();
    }

    @Override
    public void invalidateAll() {
        if (this.cachedCapability != null && this.cachedCapability.isPresent()) {
            this.cachedCapability.invalidate();
            this.cachedCapability = null;
        }
    }
}

