/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.Iterator;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.distribution.EnergySaveTarget;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
public class ModuleChargeDistributionUnit
implements ICustomModule<ModuleChargeDistributionUnit> {
    private IModuleConfigItem<Boolean> chargeSuit;
    private IModuleConfigItem<Boolean> chargeInventory;

    @Override
    public void init(IModule<ModuleChargeDistributionUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.chargeSuit = configItemCreator.createConfigItem("charge_suit", MekanismLang.MODULE_CHARGE_SUIT, new ModuleBooleanData());
        this.chargeInventory = configItemCreator.createConfigItem("charge_inventory", MekanismLang.MODULE_CHARGE_INVENTORY, new ModuleBooleanData(false));
    }

    @Override
    public void tickServer(IModule<ModuleChargeDistributionUnit> module, PlayerEntity player) {
        if (this.chargeInventory.get().booleanValue()) {
            this.chargeInventory(module, player);
        }
        if (this.chargeSuit.get().booleanValue()) {
            this.chargeSuit(player);
        }
    }

    private void chargeSuit(PlayerEntity player) {
        FloatingLong total = FloatingLong.ZERO;
        EnergySaveTarget saveTarget = new EnergySaveTarget(4);
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) continue;
            saveTarget.addDelegate(energyContainer);
            total = total.plusEqual(energyContainer.getEnergy());
        }
        EmitUtils.sendToAcceptors(saveTarget, total);
        saveTarget.save();
    }

    private void chargeInventory(IModule<ModuleChargeDistributionUnit> module, PlayerEntity player) {
        FloatingLong toCharge = (FloatingLong)MekanismConfig.gear.mekaSuitInventoryChargeRate.get();
        toCharge = this.charge(module, player, player.func_184614_ca(), toCharge);
        toCharge = this.charge(module, player, player.func_184592_cb(), toCharge);
        if (!toCharge.isZero()) {
            Optional<? extends IItemHandler> curiosInventory;
            ItemStack stack;
            Iterator iterator = player.field_71071_by.field_70462_a.iterator();
            while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()) == player.func_184614_ca() || stack == player.func_184592_cb() || !(toCharge = this.charge(module, player, stack, toCharge)).isZero())) {
            }
            if (!toCharge.isZero() && Mekanism.hooks.CuriosLoaded && (curiosInventory = MekanismHooks.getCuriosInventory((LivingEntity)player)).isPresent()) {
                IItemHandler handler = curiosInventory.get();
                int slots = handler.getSlots();
                for (int slot = 0; slot < slots && !(toCharge = this.charge(module, player, handler.getStackInSlot(slot), toCharge)).isZero(); ++slot) {
                }
            }
        }
    }

    private FloatingLong charge(IModule<ModuleChargeDistributionUnit> module, PlayerEntity player, ItemStack stack, FloatingLong amount) {
        FloatingLong remaining;
        IStrictEnergyHandler handler;
        if (!stack.func_190926_b() && !amount.isZero() && (handler = EnergyCompatUtils.getStrictEnergyHandler(stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)).smallerThan(amount)) {
            return handler.insertEnergy(module.useEnergy((LivingEntity)player, amount.subtract(remaining), false), Action.EXECUTE).add(remaining);
        }
        return amount;
    }
}

