/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public class ModuleGravitationalModulatingUnit
implements ICustomModule<ModuleGravitationalModulatingUnit> {
    private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "gravitational_modulation_unit.png");
    private IModuleConfigItem<ModuleLocomotiveBoostingUnit.SprintBoost> speedBoost;

    @Override
    public void init(IModule<ModuleGravitationalModulatingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.speedBoost = configItemCreator.createConfigItem("speed_boost", MekanismLang.MODULE_SPEED_BOOST, new ModuleEnumData<ModuleLocomotiveBoostingUnit.SprintBoost>(ModuleLocomotiveBoostingUnit.SprintBoost.class, ModuleLocomotiveBoostingUnit.SprintBoost.LOW));
    }

    @Override
    public void addHUDElements(IModule<ModuleGravitationalModulatingUnit> module, PlayerEntity player, Consumer<IHUDElement> hudElementAdder) {
        hudElementAdder.accept(MekanismAPI.getModuleHelper().hudElementEnabled(icon, module.isEnabled()));
    }

    @Override
    public boolean canChangeModeWhenDisabled(IModule<ModuleGravitationalModulatingUnit> module) {
        return true;
    }

    @Override
    public void changeMode(IModule<ModuleGravitationalModulatingUnit> module, PlayerEntity player, ItemStack stack, int shift, boolean displayChangeMessage) {
        module.toggleEnabled(player, (ITextComponent)MekanismLang.MODULE_GRAVITATIONAL_MODULATION.translate(new Object[0]));
    }

    public float getBoost() {
        return this.speedBoost.get().getBoost();
    }

    @Override
    public void tickClient(IModule<ModuleGravitationalModulatingUnit> module, PlayerEntity player) {
        float boost;
        if (player.field_71075_bZ.field_75100_b && MekanismKeyHandler.boostKey.func_151470_d() && module.canUseEnergy((LivingEntity)player, ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get()).multiply(4L), false) && (boost = this.getBoost()) > 0.0f) {
            player.func_213309_a(boost, new Vector3d(0.0, 0.0, 1.0));
        }
    }
}

