/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSPigment;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@RecipeTypeMapper
public class PigmentMixerRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekPigmentMixer";
    }

    public String getDescription() {
        return "Maps Mekanism pigment mixer recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.PIGMENT_MIXING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof PigmentMixingRecipe)) {
            return false;
        }
        boolean handled = false;
        PigmentMixingRecipe recipe = (PigmentMixingRecipe)iRecipe;
        List<@NonNull TYPE> leftInputRepresentations = ((PigmentStackIngredient)recipe.getLeftInput()).getRepresentations();
        List<@NonNull TYPE> rightInputRepresentations = ((PigmentStackIngredient)recipe.getRightInput()).getRepresentations();
        for (PigmentStack leftRepresentation : leftInputRepresentations) {
            NSSPigment nssLeft = NSSPigment.createPigment(leftRepresentation);
            for (PigmentStack rightRepresentation : rightInputRepresentations) {
                PigmentStack output = recipe.getOutput(leftRepresentation, rightRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssLeft, leftRepresentation.getAmount());
                ingredientHelper.put(rightRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

