/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IFrequencyItem
extends IOwnerItem {
    @Override
    default public void setOwnerUUID(@Nonnull ItemStack stack, @Nullable UUID owner) {
        this.setFrequency(stack, null);
        IOwnerItem.super.setOwnerUUID(stack, owner);
    }

    @Nullable
    default public Frequency.FrequencyIdentity getFrequencyIdentity(ItemStack stack) {
        if (this.hasFrequency(stack)) {
            return Frequency.FrequencyIdentity.load(this.getFrequencyType(), ItemDataUtils.getCompound(stack, "frequency"));
        }
        return null;
    }

    default public boolean hasFrequency(ItemStack stack) {
        return ItemDataUtils.hasData(stack, "frequency", 10);
    }

    @Nullable
    default public Frequency getFrequency(ItemStack stack) {
        if (this.hasFrequency(stack)) {
            CompoundNBT frequencyCompound = ItemDataUtils.getCompound(stack, "frequency");
            Frequency.FrequencyIdentity identity = Frequency.FrequencyIdentity.load(this.getFrequencyType(), frequencyCompound);
            if (identity != null) {
                UUID owner;
                if (frequencyCompound.func_186855_b("owner")) {
                    owner = frequencyCompound.func_186857_a("owner");
                } else {
                    owner = this.getOwnerUUID(stack);
                    if (owner == null) {
                        return null;
                    }
                }
                return this.getFrequencyType().getManager(identity, owner).getFrequency(identity.getKey());
            }
        }
        return null;
    }

    default public void setFrequency(ItemStack stack, Frequency frequency) {
        if (frequency == null) {
            ItemDataUtils.removeData(stack, "frequency");
        } else {
            ItemDataUtils.setCompound(stack, "frequency", frequency.serializeIdentityWithOwner());
        }
    }

    public FrequencyType<?> getFrequencyType();
}

