/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayerData
implements IMekanismPacket {
    private final UUID uuid;
    private final boolean activeFlamethrower;
    private final boolean activeJetpack;
    private final boolean activeScubaMask;
    private final boolean activeModulator;

    public PacketPlayerData(UUID uuid) {
        this.uuid = uuid;
        this.activeFlamethrower = Mekanism.playerState.getActiveFlamethrowers().contains(uuid);
        this.activeJetpack = Mekanism.playerState.getActiveJetpacks().contains(uuid);
        this.activeScubaMask = Mekanism.playerState.getActiveScubaMasks().contains(uuid);
        this.activeModulator = Mekanism.playerState.getActiveGravitationalModulators().contains(uuid);
    }

    private PacketPlayerData(UUID uuid, boolean activeFlamethrower, boolean activeJetpack, boolean activeGasMask, boolean activeModulator) {
        this.uuid = uuid;
        this.activeFlamethrower = activeFlamethrower;
        this.activeJetpack = activeJetpack;
        this.activeScubaMask = activeGasMask;
        this.activeModulator = activeModulator;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Mekanism.playerState.setFlamethrowerState(this.uuid, this.activeFlamethrower, false);
        Mekanism.playerState.setJetpackState(this.uuid, this.activeJetpack, false);
        Mekanism.playerState.setScubaMaskState(this.uuid, this.activeScubaMask, false);
        Mekanism.playerState.setGravitationalModulationState(this.uuid, this.activeModulator, false);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.uuid);
        buffer.writeBoolean(this.activeFlamethrower);
        buffer.writeBoolean(this.activeJetpack);
        buffer.writeBoolean(this.activeScubaMask);
        buffer.writeBoolean(this.activeModulator);
    }

    public static PacketPlayerData decode(PacketBuffer buffer) {
        return new PacketPlayerData(buffer.func_179253_g(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
    }
}

