/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateTile
implements IMekanismPacket {
    private final CompoundNBT updateTag;
    private final BlockPos pos;

    public PacketUpdateTile(TileEntityUpdateable tile) {
        this(tile.func_174877_v(), tile.getReducedUpdateTag());
    }

    private PacketUpdateTile(BlockPos pos, CompoundNBT updateTag) {
        this.pos = pos;
        this.updateTag = updateTag;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            TileEntityUpdateable tile = WorldUtils.getTileEntity(TileEntityUpdateable.class, (IBlockReader)world, this.pos, true);
            if (tile == null) {
                Mekanism.logger.info("Update tile packet received for position: {} in world: {}, but no valid tile was found.", (Object)this.pos, (Object)world.func_234923_W_().func_240901_a_());
            } else {
                tile.handleUpdatePacket(this.updateTag);
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_150786_a(this.updateTag);
    }

    public static PacketUpdateTile decode(PacketBuffer buffer) {
        return new PacketUpdateTile(buffer.func_179259_c(), buffer.func_150793_b());
    }
}

