/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.recipe.lookup.cache.type.NBTSensitiveInputCache;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.NBTIngredient;

public class ItemInputCache<RECIPE extends MekanismRecipe>
extends NBTSensitiveInputCache<Item, HashedItem, ItemStack, ItemStackIngredient, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, ItemStackIngredient inputIngredient) {
        if (inputIngredient instanceof ItemStackIngredient.Single) {
            return this.mapIngredient(recipe, ((ItemStackIngredient.Single)inputIngredient).getInputRaw());
        }
        if (inputIngredient instanceof ItemStackIngredient.Multi) {
            return ((ItemStackIngredient.Multi)inputIngredient).forEachIngredient(ingredient -> this.mapInputs(recipe, (ItemStackIngredient)ingredient));
        }
        return true;
    }

    private boolean mapIngredient(RECIPE recipe, Ingredient input) {
        if (input.isVanilla() || input.isSimple()) {
            for (ItemStack item : input.func_193365_a()) {
                this.addInputCache(item.func_77973_b(), recipe);
            }
        } else {
            if (input instanceof CompoundIngredient) {
                CompoundIngredient compoundIngredient = (CompoundIngredient)input;
                boolean result = false;
                for (Ingredient child : compoundIngredient.getChildren()) {
                    result |= this.mapIngredient(recipe, child);
                }
                return result;
            }
            if (input instanceof NBTIngredient) {
                this.addNbtInputCache(HashedItem.create(input.func_193365_a()[0]), recipe);
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Item createKey(ItemStack stack) {
        return stack.func_77973_b();
    }

    @Override
    protected HashedItem createNbtKey(ItemStack stack) {
        return HashedItem.raw(stack);
    }

    @Override
    public boolean isEmpty(ItemStack input) {
        return input.func_190926_b();
    }
}

