/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class QIORecipeData
implements RecipeUpgradeData<QIORecipeData> {
    private final Object2LongMap<HashedItem> itemMap;
    private final long itemCount;

    QIORecipeData(IQIODriveItem.DriveMetadata data, ListNBT nbtItemMap) {
        this.itemCount = data.getCount();
        this.itemMap = new Object2LongOpenHashMap(data.getTypes());
        for (int i = 0; i < nbtItemMap.size(); ++i) {
            CompoundNBT tag = nbtItemMap.func_150305_b(i);
            ItemStack itemType = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item"));
            this.itemMap.put((Object)HashedItem.create(itemType), tag.func_74763_f("amount"));
        }
    }

    private QIORecipeData(Object2LongMap<HashedItem> itemMap, long itemCount) {
        this.itemMap = itemMap;
        this.itemCount = itemCount;
    }

    @Override
    @Nullable
    public QIORecipeData merge(QIORecipeData other) {
        if (this.itemCount <= Long.MAX_VALUE - other.itemCount) {
            Object2LongOpenHashMap fullItemMap = new Object2LongOpenHashMap();
            fullItemMap.putAll(this.itemMap);
            for (Object2LongMap.Entry entry : other.itemMap.object2LongEntrySet()) {
                HashedItem type = (HashedItem)entry.getKey();
                fullItemMap.put((Object)type, fullItemMap.getOrDefault((Object)type, 0L) + entry.getLongValue());
            }
            return new QIORecipeData((Object2LongMap<HashedItem>)fullItemMap, this.itemCount + other.itemCount);
        }
        return null;
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        IQIODriveItem driveItem = (IQIODriveItem)stack.func_77973_b();
        if (this.itemCount > driveItem.getCountCapacity(stack) || this.itemMap.size() > driveItem.getTypeCapacity(stack)) {
            return false;
        }
        ListNBT list = new ListNBT();
        for (Object2LongMap.Entry entry : this.itemMap.object2LongEntrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("Item", (INBT)((HashedItem)entry.getKey()).getStack().func_77955_b(new CompoundNBT()));
            tag.func_74772_a("amount", entry.getLongValue());
            list.add((Object)tag);
        }
        ItemDataUtils.setList(stack, "qioItemMap", list);
        IQIODriveItem.DriveMetadata meta = new IQIODriveItem.DriveMetadata(this.itemCount, this.itemMap.size());
        meta.write(stack);
        return true;
    }
}

