/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.resource;

import java.util.function.Supplier;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.OreType;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.Tags;

public enum PrimaryResource implements IResource
{
    IRON("iron", -5271945, (ITag<Item>)Tags.Items.ORES_IRON),
    GOLD("gold", -864921, (ITag<Item>)Tags.Items.ORES_GOLD),
    OSMIUM("osmium", -14779965, () -> MekanismTags.Items.ORES.get((Object)OreType.OSMIUM), BlockResourceInfo.OSMIUM),
    COPPER("copper", -5616871, () -> MekanismTags.Items.ORES.get((Object)OreType.COPPER), BlockResourceInfo.COPPER),
    TIN("tin", -3355431, () -> MekanismTags.Items.ORES.get((Object)OreType.TIN), BlockResourceInfo.TIN),
    LEAD("lead", -12959670, () -> MekanismTags.Items.ORES.get((Object)OreType.LEAD), BlockResourceInfo.LEAD),
    URANIUM("uranium", -12163505, () -> MekanismTags.Items.ORES.get((Object)OreType.URANIUM), BlockResourceInfo.URANIUM);

    private final String name;
    private final int tint;
    private final Supplier<ITag<Item>> oreTag;
    private final boolean isVanilla;
    private final BlockResourceInfo resourceBlockInfo;

    private PrimaryResource(String name, int tint, ITag<Item> oreTag) {
        this(name, tint, () -> oreTag, true, null);
    }

    private PrimaryResource(String name, int tint, Supplier<ITag<Item>> oreTag, BlockResourceInfo resourceBlockInfo) {
        this(name, tint, oreTag, false, resourceBlockInfo);
    }

    private PrimaryResource(String name, int tint, Supplier<ITag<Item>> oreTag, boolean isVanilla, BlockResourceInfo resourceBlockInfo) {
        this.name = name;
        this.tint = tint;
        this.oreTag = oreTag;
        this.isVanilla = isVanilla;
        this.resourceBlockInfo = resourceBlockInfo;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getRegistrySuffix() {
        return this.name;
    }

    public int getTint() {
        return this.tint;
    }

    public ITag<Item> getOreTag() {
        return this.oreTag.get();
    }

    public boolean has(ResourceType type) {
        return type != ResourceType.ENRICHED && (!this.isVanilla || type != ResourceType.INGOT && type != ResourceType.NUGGET);
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public BlockResourceInfo getResourceBlockInfo() {
        return this.resourceBlockInfo;
    }
}

