/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.MathUtils;

public interface ITileRadioactive {
    public static float calculateRadiationScale(List<IGasTank> tanks) {
        if (MekanismAPI.getRadiationManager().isRadiationEnabled() && !tanks.isEmpty()) {
            float summedScale = 0.0f;
            for (IGasTank tank : tanks) {
                if (tank.isEmpty() || !((GasStack)tank.getStack()).has(GasAttributes.Radiation.class)) continue;
                summedScale += (float)tank.getStored() / (float)tank.getCapacity();
            }
            return summedScale / (float)tanks.size();
        }
        return 0.0f;
    }

    public float getRadiationScale();

    default public int getRadiationParticleCount() {
        return MathUtils.clampToInt(10.0f * this.getRadiationScale());
    }
}

