/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.common.content.network.distribution.FluidHandlerTarget;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public final class FluidUtils {
    private FluidUtils() {
    }

    public static void emit(IExtendedFluidTank tank, TileEntity from) {
        FluidUtils.emit(EnumSet.allOf(Direction.class), tank, from);
    }

    public static void emit(Set<Direction> outputSides, IExtendedFluidTank tank, TileEntity from) {
        FluidUtils.emit(outputSides, tank, from, tank.getCapacity());
    }

    public static void emit(Set<Direction> outputSides, IExtendedFluidTank tank, TileEntity from, int maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0) {
            tank.extract(FluidUtils.emit(outputSides, tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL), from), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static int emit(Set<Direction> sides, @Nonnull FluidStack stack, TileEntity from) {
        if (stack.isEmpty() || sides.isEmpty()) {
            return 0;
        }
        FluidStack toSend = stack.copy();
        FluidHandlerTarget target = new FluidHandlerTarget(stack, 6);
        EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> CapabilityUtils.getCapability((ICapabilityProvider)acceptor, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()).ifPresent(handler -> {
            if (FluidUtils.canFill(handler, toSend)) {
                target.addHandler(handler);
            }
        }));
        if (target.getHandlerCount() > 0) {
            return EmitUtils.sendToAcceptors(target, stack.getAmount(), toSend);
        }
        return 0;
    }

    public static boolean canFill(IFluidHandler handler, @Nonnull FluidStack stack) {
        return handler.fill(stack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public static boolean handleTankInteraction(PlayerEntity player, Hand hand, ItemStack itemStack, IExtendedFluidTank fluidTank) {
        ItemStack copyStack = StackUtils.size(itemStack, 1);
        Optional fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)copyStack).resolve();
        if (fluidHandlerItem.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerItem.get();
            FluidStack fluidInItem = fluidTank.isEmpty() ? handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : handler.drain(new FluidStack(fluidTank.getFluid(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            if (fluidInItem.isEmpty()) {
                if (!fluidTank.isEmpty()) {
                    int filled = handler.fill(fluidTank.getFluid(), player.func_184812_l_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = handler.getContainer();
                    if (filled > 0) {
                        if (itemStack.func_190916_E() == 1) {
                            player.func_184611_a(hand, container);
                        } else if (itemStack.func_190916_E() > 1 && player.field_71071_by.func_70441_a(container)) {
                            itemStack.func_190918_g(1);
                        } else {
                            player.func_146097_a(container, false, true);
                            itemStack.func_190918_g(1);
                        }
                        fluidTank.extract(filled, Action.EXECUTE, AutomationType.MANUAL);
                        return true;
                    }
                }
            } else {
                int storedAmount;
                FluidStack simulatedRemainder = fluidTank.insert(fluidInItem, Action.SIMULATE, AutomationType.MANUAL);
                int remainder = simulatedRemainder.getAmount();
                if (remainder < (storedAmount = fluidInItem.getAmount())) {
                    boolean filled = false;
                    FluidStack drained = handler.drain(new FluidStack(fluidInItem, storedAmount - remainder), player.func_184812_l_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    if (!drained.isEmpty()) {
                        ItemStack container = handler.getContainer();
                        if (player.func_184812_l_()) {
                            filled = true;
                        } else if (!container.func_190926_b()) {
                            if (itemStack.func_190916_E() == 1) {
                                player.func_184611_a(hand, container);
                                filled = true;
                            } else if (player.field_71071_by.func_70441_a(container)) {
                                itemStack.func_190918_g(1);
                                filled = true;
                            }
                        } else {
                            itemStack.func_190918_g(1);
                            if (itemStack.func_190926_b()) {
                                player.func_184611_a(hand, ItemStack.field_190927_a);
                            }
                            filled = true;
                        }
                        if (filled) {
                            fluidTank.insert(drained, Action.EXECUTE, AutomationType.MANUAL);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

