/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.material.IPaxelMaterial;
import mekanism.tools.common.material.VanillaPaxelMaterial;
import net.minecraft.item.ItemTier;
import net.minecraftforge.common.ForgeConfigSpec;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class VanillaPaxelMaterialCreator
implements IPaxelMaterial {
    private final VanillaPaxelMaterial fallback;
    private final CachedIntValue paxelHarvestLevel;
    public final CachedFloatValue paxelDamage;
    public final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelMaxUses;

    public VanillaPaxelMaterialCreator(IMekanismConfig config, ForgeConfigSpec.Builder builder, VanillaPaxelMaterial materialDefaults) {
        this.fallback = materialDefaults;
        String toolKey = this.getRegistryPrefix();
        String name = this.getConfigCommentName();
        builder.comment("Vanilla Material Paxel Settings for " + name).push(toolKey);
        this.paxelHarvestLevel = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Harvest level of " + name + " paxels.").defineInRange(toolKey + "PaxelHarvestLevel", materialDefaults.getPaxelHarvestLevel(), 0, Integer.MAX_VALUE));
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " paxels.").define(toolKey + "PaxelDamage", (Object)materialDefaults.getPaxelDamage(), value -> {
            if (value instanceof Double) {
                double val = (Double)value;
                float actualValue = val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : (float)val);
                float baseDamage = this.getVanillaTier().func_200929_c();
                return actualValue >= -baseDamage && actualValue <= Float.MAX_VALUE - baseDamage;
            }
            return false;
        }));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " paxels.").define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " paxels.").define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " paxels.").defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " paxels.").defineInRange(toolKey + "PaxelMaxUses", materialDefaults.getPaxelMaxUses(), 1, Integer.MAX_VALUE));
        builder.pop();
    }

    @Nonnull
    public ItemTier getVanillaTier() {
        return this.fallback.getVanillaTier();
    }

    @Nonnull
    public String getRegistryPrefix() {
        return this.fallback.getRegistryPrefix();
    }

    @Override
    public int getPaxelHarvestLevel() {
        return this.paxelHarvestLevel.get();
    }

    @Override
    public int getPaxelMaxUses() {
        return this.paxelMaxUses.get();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.get();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.get();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }

    @Override
    public String getConfigCommentName() {
        return this.fallback.getConfigCommentName();
    }
}

