/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fuzs.puzzleslib.util.NamespaceUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public class RegistryManager {
    private final Multimap<Class<?>, Pair<ResourceLocation, Supplier<IForgeRegistryEntry<?>>>> registryEntryPairs = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    private RegistryManager() {
    }

    @SubscribeEvent
    public void onRegistryRegister(RegistryEvent.Register<?> evt) {
        this.addAllToRegistry(evt.getRegistry());
    }

    private <T extends IForgeRegistryEntry<T>> void addAllToRegistry(IForgeRegistry<T> registry) {
        Class type = registry.getRegistrySuperType();
        if (this.registryEntryPairs.containsKey((Object)type)) {
            for (Pair registryPair : this.registryEntryPairs.get((Object)type)) {
                ResourceLocation name = (ResourceLocation)registryPair.getLeft();
                IForgeRegistryEntry entry = (IForgeRegistryEntry)((Supplier)registryPair.getRight()).get();
                if (entry == null) {
                    throw new IllegalArgumentException("Can't register null object.");
                }
                if (entry.getRegistryName() == null) {
                    assert (name != null);
                    entry.setRegistryName(name);
                }
                registry.register(entry);
            }
            this.registryEntryPairs.removeAll((Object)type);
        }
    }

    @Deprecated
    public void register(IForgeRegistryEntry<?> entry) {
        this.register(null, entry);
    }

    @Deprecated
    public void register(@Nullable String path, IForgeRegistryEntry<?> entry) {
        this.register(entry.getRegistryType(), path, () -> entry);
    }

    public void register(Class<?> registryType, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(registryType, null, entry);
    }

    public void register(Class<?> registryType, @Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        ResourceLocation name = null;
        if (path != null) {
            name = NamespaceUtil.locate(path);
        }
        this.registryEntryPairs.put(registryType, (Object)Pair.of((Object)name, entry));
    }

    public void registerBlockWithItem(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry, ItemGroup creativeTab) {
        this.registerBlockWithItem(path, entry, new Item.Properties().func_200916_a(creativeTab));
    }

    public void registerBlockWithItem(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry, Item.Properties properties) {
        this.registerBlock(path, entry);
        ResourceLocation location = NamespaceUtil.locate(path);
        this.registerItem(path, () -> {
            Block block = path != null ? (Block)ForgeRegistries.BLOCKS.getValue(location) : (Block)entry.get();
            return block != null ? new BlockItem(block, properties) : null;
        });
    }

    public void registerBlock(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(Block.class, path, entry);
    }

    public void registerFluid(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(Fluid.class, path, entry);
    }

    public void registerItem(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(Item.class, path, entry);
    }

    public void registerEffect(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(Effect.class, path, entry);
    }

    public void registerSoundEvent(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(SoundEvent.class, path, entry);
    }

    public void registerPotion(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(Potion.class, path, entry);
    }

    public void registerEnchantment(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(Enchantment.class, path, entry);
    }

    public void registerEntityType(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(EntityType.class, path, entry);
    }

    public void registerTileEntityType(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(TileEntityType.class, path, entry);
    }

    public void registerContainerType(@Nullable String path, Supplier<IForgeRegistryEntry<?>> entry) {
        this.register(ContainerType.class, path, entry);
    }

    public static RegistryManager getInstance() {
        return RegistryManagerHolder.INSTANCE;
    }

    private static class RegistryManagerHolder {
        private static final RegistryManager INSTANCE = new RegistryManager();

        private RegistryManagerHolder() {
        }
    }
}

