/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.anointment.AnointmentColor;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.client.model.MimicColor;
import wayoftime.bloodmagic.client.render.RenderItemRoutingNode;
import wayoftime.bloodmagic.client.render.alchemyarray.BeaconAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.DayAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.LowStaticAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.NightAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.StaticAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.block.RenderAlchemyArray;
import wayoftime.bloodmagic.client.render.block.RenderAltar;
import wayoftime.bloodmagic.client.render.block.RenderDemonCrucible;
import wayoftime.bloodmagic.client.render.entity.BloodLightRenderer;
import wayoftime.bloodmagic.client.render.entity.EntityShapedChargeRenderer;
import wayoftime.bloodmagic.client.render.entity.EntityThrowingDaggerRenderer;
import wayoftime.bloodmagic.client.render.entity.SoulSnareRenderer;
import wayoftime.bloodmagic.client.render.entity.layers.BloodElytraLayer;
import wayoftime.bloodmagic.client.screens.ScreenAlchemicalReactionChamber;
import wayoftime.bloodmagic.client.screens.ScreenAlchemyTable;
import wayoftime.bloodmagic.client.screens.ScreenFilter;
import wayoftime.bloodmagic.client.screens.ScreenHolding;
import wayoftime.bloodmagic.client.screens.ScreenItemRoutingNode;
import wayoftime.bloodmagic.client.screens.ScreenSoulForge;
import wayoftime.bloodmagic.client.screens.ScreenTrainingBracelet;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ItemSacrificialDagger;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilToggleable;
import wayoftime.bloodmagic.common.item.soul.ItemSentientSword;
import wayoftime.bloodmagic.common.registries.BloodMagicEntityTypes;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRendererRegistry;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.network.SigilHoldingPacket;
import wayoftime.bloodmagic.tile.TileAlchemyArray;
import wayoftime.bloodmagic.tile.TileAltar;
import wayoftime.bloodmagic.tile.TileDemonCrucible;
import wayoftime.bloodmagic.tile.routing.TileInputRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileOutputRoutingNode;
import wayoftime.bloodmagic.tile.routing.TileRoutingNode;
import wayoftime.bloodmagic.util.GhostItemHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientRegistry.bindTileEntityRenderer(TileAltar.TYPE, RenderAltar::new);
        ClientRegistry.bindTileEntityRenderer(TileAlchemyArray.TYPE, RenderAlchemyArray::new);
        ClientRegistry.bindTileEntityRenderer(TileDemonCrucible.TYPE, RenderDemonCrucible::new);
        ClientRegistry.bindTileEntityRenderer(TileRoutingNode.TYPE, RenderItemRoutingNode::new);
        ClientRegistry.bindTileEntityRenderer(TileInputRoutingNode.TYPE, RenderItemRoutingNode::new);
        ClientRegistry.bindTileEntityRenderer(TileOutputRoutingNode.TYPE, RenderItemRoutingNode::new);
    }

    public static void registerContainerScreens() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.SOUL_FORGE_CONTAINER.get()), ScreenSoulForge::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.ARC_CONTAINER.get()), ScreenAlchemicalReactionChamber::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.ALCHEMY_TABLE_CONTAINER.get()), ScreenAlchemyTable::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.HOLDING_CONTAINER.get()), ScreenHolding::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.FILTER_CONTAINER.get()), ScreenFilter::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.ROUTING_NODE_CONTAINER.get()), ScreenItemRoutingNode::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)BloodMagicBlocks.TRAINING_BRACELET_CONTAINER.get()), ScreenTrainingBracelet::new);
    }

    public static void colorHandlerEvent(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((IItemColor)new AnointmentColor(), new IItemProvider[]{(IItemProvider)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.SILK_TOUCH_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.FORTUNE_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.LOOTING_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.WILL_POWER_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.SMELTING_ANOINTMENT.get(), (IItemProvider)BloodMagicItems.BOW_VELOCITY_ANOINTMENT.get()});
        event.getItemColors().func_199877_a((IItemColor)new AnointmentColor(), new IItemProvider[]{(IItemProvider)BloodMagicItems.BOW_POWER_ANOINTMENT_STRONG.get()});
        event.getItemColors().func_199877_a((IItemColor)new AnointmentColor(), new IItemProvider[]{(IItemProvider)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.SILK_TOUCH_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.FORTUNE_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.HOLY_WATER_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.QUICK_DRAW_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.LOOTING_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.BOW_POWER_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.SMELTING_ANOINTMENT_L.get(), (IItemProvider)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_L.get()});
        event.getItemColors().func_199877_a((IItemColor)new AnointmentColor(), new IItemProvider[]{(IItemProvider)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.FORTUNE_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.HOLY_WATER_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.QUICK_DRAW_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.LOOTING_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.BOW_POWER_ANOINTMENT_2.get(), (IItemProvider)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_2.get()});
    }

    public static void cycleSigil(ItemStack stack, PlayerEntity player, int dWheel) {
        int mode = dWheel;
        if (!((Boolean)ConfigManager.CLIENT.sigilHoldingSkipsEmptySlots.get()).booleanValue()) {
            mode = ItemSigilHolding.getCurrentItemOrdinal(stack);
            mode = dWheel < 0 ? ItemSigilHolding.next(mode) : ItemSigilHolding.prev(mode);
        }
        ItemSigilHolding.cycleToNextSigil(stack, mode);
        BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new SigilHoldingPacket(player.field_71071_by.field_70461_c, mode));
        ItemStack newStack = ItemSigilHolding.getItemStackInSlot(stack, ItemSigilHolding.getCurrentItemOrdinal(stack));
        player.func_146105_b((ITextComponent)(newStack.func_190926_b() ? new StringTextComponent("") : newStack.func_151000_E()), true);
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        Item item;
        ItemStack stack;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getScrollDelta() != 0.0 && player != null && player.func_225608_bj_() && !(stack = player.func_184614_ca()).func_190926_b() && (item = stack.func_77973_b()) instanceof ItemSigilHolding) {
            ClientEvents.cycleSigil(stack, (PlayerEntity)player, event.getScrollDelta() > 0.0 ? 1 : -1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void appendTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        AnointmentHolder holder = AnointmentHolder.fromItemStack(stack);
        AnointmentHolder.appendAnointmentTooltip(holder, event.getToolTip());
        if (GhostItemHelper.hasGhostAmount(stack)) {
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            if (amount == 0) {
                event.getToolTip().add(new TranslationTextComponent("tooltip.bloodmagic.ghost.everything"));
            } else {
                event.getToolTip().add(new TranslationTextComponent("tooltip.bloodmagic.ghost.amount", new Object[]{amount}));
            }
        }
    }

    public static void initClientEvents(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(BloodMagicEntityTypes.SNARE.getEntityType(), SoulSnareRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(BloodMagicEntityTypes.THROWING_DAGGER.getEntityType(), EntityThrowingDaggerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(BloodMagicEntityTypes.THROWING_DAGGER_SYRINGE.getEntityType(), EntityThrowingDaggerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(BloodMagicEntityTypes.BLOOD_LIGHT.getEntityType(), BloodLightRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(BloodMagicEntityTypes.SHAPED_CHARGE.getEntityType(), EntityShapedChargeRenderer::new);
        DeferredWorkQueue.runLater(() -> {
            RenderType rendertype = RenderType.func_228641_d_();
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.ALCHEMY_TABLE.get()), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.GROWING_DOUBT.get()), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.WEAK_TAU.get()), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.STRONG_TAU.get()), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.SPIKES.get()), (RenderType)rendertype);
            ClientEvents.registerContainerScreens();
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.GREEN_GROVE_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.FAST_MINER_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.MAGNETISM_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.ICE_SIGIL.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_SWORD.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_AXE.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_PICKAXE.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_SHOVEL.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_SCYTHE.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.PETTY_GEM.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.LESSER_GEM.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.COMMON_GEM.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.GREATER_GEM.get());
            ClientEvents.registerSacrificialKnife((Item)BloodMagicItems.SACRIFICIAL_DAGGER.get());
            ItemModelsProperties.func_239418_a_((Item)((Item)BloodMagicItems.SENTIENT_SWORD.get()), (ResourceLocation)BloodMagic.rl("active"), (IItemPropertyGetter)new IItemPropertyGetter(){

                public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
                    return ((ItemSentientSword)stack.func_77973_b()).getActivated(stack) ? 1.0f : 0.0f;
                }
            });
            Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new MimicColor(), new Block[]{(Block)BloodMagicBlocks.MIMIC.get()});
            RenderTypeLookup.setRenderLayer((Block)((Block)BloodMagicBlocks.MIMIC.get()), RenderType2 -> true);
        });
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/movement"), new StaticAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/movementarray.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/updraft"), new BeaconAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/updraftarray.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/spike"), new LowStaticAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/spikearray.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/day"), new DayAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/sunarray.png"), BloodMagic.rl("textures/models/alchemyarrays/sunarrayspikes.png"), BloodMagic.rl("textures/models/alchemyarrays/sunarraycircle.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/night"), new NightAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/moonarrayoutside.png"), BloodMagic.rl("textures/models/alchemyarrays/moonarraysymbols.png"), BloodMagic.rl("textures/models/alchemyarrays/moonarrayinside.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/grove"), new BeaconAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/growthsigil.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/bounce"), new LowStaticAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/bouncearray.png")));
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
        render.func_177094_a(new BloodElytraLayer((IEntityRenderer)render));
        render = (PlayerRenderer)skinMap.get("slim");
        render.func_177094_a(new BloodElytraLayer((IEntityRenderer)render));
    }

    public static void registerItemModelProperties(FMLClientSetupEvent event) {
    }

    public static void registerToggleableProperties(Item item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)BloodMagic.rl("active"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
                Item item = stack.func_77973_b();
                if (item instanceof ItemSigilToggleable) {
                    return ((ItemSigilToggleable)item).getActivated(stack) ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }

    public static void registerMultiWillTool(Item item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)BloodMagic.rl("type"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
                Item item = stack.func_77973_b();
                if (item instanceof IMultiWillTool) {
                    return ((IMultiWillTool)item).getCurrentType(stack).ordinal();
                }
                return 0.0f;
            }
        });
    }

    public static void registerSacrificialKnife(Item item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)BloodMagic.rl("incense"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
                Item item = stack.func_77973_b();
                if (item instanceof ItemSacrificialDagger) {
                    return ((ItemSacrificialDagger)item).canUseForSacrifice(stack) ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }
}

