/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.client.hud.element.HUDElement;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;

public class ElementDemonAura
extends HUDElement {
    private static final ResourceLocation BAR_LOCATION = new ResourceLocation("bloodmagic", "textures/hud/bars.png");
    private final List<EnumDemonWillType> orderedTypes = Lists.newArrayList((Object[])new EnumDemonWillType[]{EnumDemonWillType.DEFAULT, EnumDemonWillType.CORROSIVE, EnumDemonWillType.STEADFAST, EnumDemonWillType.DESTRUCTIVE, EnumDemonWillType.VENGEFUL});

    public ElementDemonAura() {
        super(80, 46);
    }

    @Override
    public void draw(MatrixStack matrixStack, float partialTicks, int drawX, int drawY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        minecraft.func_110434_K().func_110577_a(BAR_LOCATION);
        this.blit(matrixStack, drawX, drawY, 0, 210, 80, 46);
        double maxAmount = Utils.getDemonWillResolution((PlayerEntity)player);
        int i = 0;
        for (EnumDemonWillType type : this.orderedTypes) {
            minecraft.func_110434_K().func_110577_a(BAR_LOCATION);
            int textureXOffset = ++i > 3 ? i - 3 : 3 - i;
            int maxBarSize = 30 - 2 * textureXOffset;
            double amount = ClientHandler.currentAura == null ? 0.0 : ClientHandler.currentAura.getWill(type);
            double ratio = Math.max(Math.min(amount / maxAmount, 1.0), 0.0);
            double width = (double)maxBarSize * ratio * 2.0;
            double height = 2.0;
            double x = drawX + 2 * textureXOffset + 10;
            double y = drawY + 4 * i + 10;
            double textureX = 2 * textureXOffset + 84;
            double textureY = 4 * i + 220;
            this.blit(matrixStack, (int)x, (int)y, (int)textureX, (int)textureY, (int)width, (int)height);
            if (!player.func_225608_bj_()) continue;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(x - (double)(2 * textureXOffset) + 70.0, y - 2.0, 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            minecraft.field_71466_p.func_238405_a_(matrixStack, String.valueOf((int)amount), 0.0f, 2.0f, -1);
            RenderSystem.clearTexGen();
            matrixStack.func_227865_b_();
        }
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        return Utils.canPlayerSeeDemonWill((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }
}

