/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.key;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.ClientEvents;
import wayoftime.bloodmagic.client.key.IKeybindable;
import wayoftime.bloodmagic.client.key.KeyBindingBloodMagic;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;
import wayoftime.bloodmagic.network.KeyProcessorPacket;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;

public enum KeyBindings {
    OPEN_HOLDING((IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, -1){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleKeybind() {
            ItemStack itemStack = ClientHandler.minecraft.field_71439_g.func_184614_ca();
            if (itemStack.func_77973_b() instanceof IKeybindable) {
                BloodMagic.packetHandler.sendToServer(new KeyProcessorPacket(this.ordinal(), false));
            }
        }
    }
    ,
    CYCLE_HOLDING_POS((IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, -1){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleKeybind() {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.func_184614_ca().func_77973_b() instanceof ItemSigilHolding) {
                ClientEvents.cycleSigil(player.func_184614_ca(), (PlayerEntity)player, -1);
            }
        }
    }
    ,
    CYCLE_HOLDING_NEG((IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, -1){

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void handleKeybind() {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.func_184614_ca().func_77973_b() instanceof ItemSigilHolding) {
                ClientEvents.cycleSigil(player.func_184614_ca(), (PlayerEntity)player, 1);
            }
        }
    };

    private final IKeyConflictContext keyConflictContext;
    private final KeyModifier keyModifier;
    private final int keyCode;
    @OnlyIn(value=Dist.CLIENT)
    private KeyBinding key;

    private KeyBindings(IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        this.keyConflictContext = keyConflictContext;
        this.keyModifier = keyModifier;
        this.keyCode = keyCode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void handleKeybind();

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    @OnlyIn(value=Dist.CLIENT)
    public KeyBinding getKey() {
        if (this.key == null) {
            this.key = new KeyBindingBloodMagic(this);
        }
        return this.key;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setKey(KeyBinding key) {
        this.key = key;
    }

    public String getDescription() {
        return "bloodmagic.keybind." + this.name().toLowerCase(Locale.ENGLISH);
    }

    public static void initializeKeys() {
        OPEN_HOLDING.getKey();
        CYCLE_HOLDING_POS.getKey();
        CYCLE_HOLDING_NEG.getKey();
    }
}

