/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ItemDemonCrystal;
import wayoftime.bloodmagic.tile.TileDemonCrystal;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class BlockDemonCrystal
extends Block {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)6);
    public static final EnumProperty<Direction> ATTACHED = EnumProperty.func_177709_a((String)"attached", Direction.class);
    private static final EnumMap<Direction, VoxelShape> bounds = new EnumMap(Direction.class);
    public final EnumDemonWillType type;
    private static final VoxelShape[] UP = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)13.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)5.0), Block.func_208617_a((double)9.0, (double)0.0, (double)9.0, (double)13.0, (double)5.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)7.0, (double)6.0, (double)7.0), Block.func_208617_a((double)5.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)7.0, (double)6.0, (double)6.0, (double)10.0), Block.func_208617_a((double)10.0, (double)0.0, (double)6.0, (double)15.0, (double)6.0, (double)9.0)};
    private static final VoxelShape[] DOWN = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)3.0, (double)7.0, (double)10.0, (double)16.0, (double)11.0), Block.func_208617_a((double)7.0, (double)10.0, (double)11.0, (double)13.0, (double)16.0, (double)16.0), Block.func_208617_a((double)9.0, (double)11.0, (double)2.0, (double)13.0, (double)16.0, (double)7.0), Block.func_208617_a((double)2.0, (double)9.0, (double)11.0, (double)7.0, (double)16.0, (double)15.0), Block.func_208617_a((double)5.0, (double)9.0, (double)1.0, (double)9.0, (double)16.0, (double)7.0), Block.func_208617_a((double)0.0, (double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0), Block.func_208617_a((double)10.0, (double)11.0, (double)7.0, (double)15.0, (double)16.0, (double)10.0)};
    private static final VoxelShape[] NORTH = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)5.0, (double)3.0, (double)10.0, (double)9.0, (double)16.0), Block.func_208617_a((double)9.0, (double)0.0, (double)6.0, (double)13.0, (double)5.0, (double)16.0), Block.func_208617_a((double)8.0, (double)9.0, (double)11.0, (double)13.0, (double)14.0, (double)16.0), Block.func_208617_a((double)2.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0), Block.func_208617_a((double)5.0, (double)9.0, (double)9.0, (double)9.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)7.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0), Block.func_208617_a((double)10.0, (double)7.0, (double)10.0, (double)15.0, (double)9.0, (double)15.0)};
    private static final VoxelShape[] SOUTH = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)7.0, (double)0.0, (double)10.0, (double)11.0, (double)13.0), Block.func_208617_a((double)7.0, (double)11.0, (double)0.0, (double)13.0, (double)16.0, (double)6.0), Block.func_208617_a((double)8.0, (double)2.0, (double)9.0, (double)13.0, (double)7.0, (double)14.0), Block.func_208617_a((double)2.0, (double)9.0, (double)1.0, (double)7.0, (double)14.0, (double)7.0), Block.func_208617_a((double)5.0, (double)1.0, (double)9.0, (double)9.0, (double)7.0, (double)9.0), Block.func_208617_a((double)0.0, (double)6.0, (double)1.0, (double)6.0, (double)9.0, (double)7.0), Block.func_208617_a((double)10.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)6.0)};
    private static final VoxelShape[] EAST = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)6.0, (double)5.0, (double)13.0, (double)10.0, (double)9.0), Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)6.0, (double)9.0, (double)5.0), Block.func_208617_a((double)0.0, (double)3.0, (double)9.0, (double)5.0, (double)8.0, (double)14.0), Block.func_208617_a((double)1.0, (double)9.0, (double)1.0, (double)7.0, (double)13.0, (double)7.0), Block.func_208617_a((double)1.0, (double)0.0, (double)9.0, (double)7.0, (double)11.0, (double)15.0), Block.func_208617_a((double)0.0, (double)10.0, (double)7.0, (double)6.0, (double)16.0, (double)10.0), Block.func_208617_a((double)0.0, (double)1.0, (double)6.0, (double)5.0, (double)6.0, (double)9.0)};
    private static final VoxelShape[] WEST = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)9.0), Block.func_208617_a((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)5.0), Block.func_208617_a((double)11.0, (double)4.0, (double)9.0, (double)16.0, (double)13.0, (double)14.0), Block.func_208617_a((double)9.0, (double)3.0, (double)1.0, (double)16.0, (double)8.0, (double)7.0), Block.func_208617_a((double)9.0, (double)6.0, (double)9.0, (double)16.0, (double)8.0, (double)15.0), Block.func_208617_a((double)10.0, (double)1.0, (double)7.0, (double)16.0, (double)6.0, (double)10.0), Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)15.0, (double)15.0, (double)9.0)};

    public BlockDemonCrystal(EnumDemonWillType type) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2));
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(ATTACHED, (Comparable)Direction.UP)).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public static ItemStack getItemStackDropped(EnumDemonWillType type, int crystalNumber) {
        ItemStack stack = ItemStack.field_190927_a;
        switch (type) {
            case CORROSIVE: {
                stack = new ItemStack((IItemProvider)BloodMagicItems.CORROSIVE_CRYSTAL.get());
                break;
            }
            case DEFAULT: {
                stack = new ItemStack((IItemProvider)BloodMagicItems.RAW_CRYSTAL.get());
                break;
            }
            case DESTRUCTIVE: {
                stack = new ItemStack((IItemProvider)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get());
                break;
            }
            case STEADFAST: {
                stack = new ItemStack((IItemProvider)BloodMagicItems.STEADFAST_CRYSTAL.get());
                break;
            }
            case VENGEFUL: {
                stack = new ItemStack((IItemProvider)BloodMagicItems.VENGEFUL_CRYSTAL.get());
            }
        }
        stack.func_190920_e(crystalNumber);
        return stack;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b(ATTACHED)) {
            case DOWN: {
                return DOWN[0];
            }
            case NORTH: {
                return NORTH[0];
            }
            case SOUTH: {
                return SOUTH[0];
            }
            case EAST: {
                return EAST[0];
            }
            case WEST: {
                return WEST[0];
            }
        }
        return UP[0];
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileDemonCrystal) {
            TileDemonCrystal crystal = (TileDemonCrystal)tile;
            boolean isCreative = player.func_184812_l_();
            boolean holdsCrystal = player.func_184586_b(hand).func_77973_b() instanceof ItemDemonCrystal;
            if (!(!(PlayerDemonWillHandler.getTotalDemonWill(PlayerDemonWillHandler.getLargestWillType(player), player) > 1024.0) || holdsCrystal && isCreative)) {
                crystal.dropSingleCrystal();
            }
            if (!crystal.func_145831_w().field_72995_K && isCreative && holdsCrystal && crystal.getCrystalCount() < 7) {
                crystal.internalCounter = 0;
                if (crystal.progressToNextCrystal > 0.0) {
                    crystal.progressToNextCrystal -= 1.0;
                }
                crystal.setCrystalCount(crystal.getCrystalCount() + 1);
                crystal.func_70296_d();
                crystal.notifyUpdate();
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b(ATTACHED);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, direction);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            Direction direction1 = direction.func_176734_d();
            if (!(blockstate = (BlockState)blockstate.func_206870_a(ATTACHED, (Comparable)direction1)).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == stateIn.func_177229_b(ATTACHED) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ATTACHED, AGE});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileDemonCrystal(this.type);
    }
}

