/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.anointment.AnointmentData;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class ItemAnointmentProvider
extends Item {
    public ResourceLocation anointRL;
    private int colour;
    private int level;
    private int maxDamage;

    public ItemAnointmentProvider(ResourceLocation anointRL, int colour, int level, int maxDamage) {
        super(new Item.Properties().func_200917_a(16).func_200916_a(BloodMagic.TAB));
        this.anointRL = anointRL;
        this.colour = colour;
        this.level = level;
        this.maxDamage = maxDamage;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack weaponStack = player.func_184586_b(hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND);
        if (!world.field_72995_K) {
            if (!weaponStack.func_190926_b() && this.isItemValidForApplication(weaponStack)) {
                AnointmentHolder holder = AnointmentHolder.fromItemStack(weaponStack);
                if (holder == null) {
                    holder = new AnointmentHolder();
                }
                if (holder.applyAnointment(weaponStack, AnointmentRegistrar.ANOINTMENT_MAP.get(this.anointRL), new AnointmentData(this.level, 0, this.maxDamage))) {
                    SoundEvent soundevent = SoundEvents.field_191241_J;
                    world.func_184133_a(null, player.func_233580_cy_(), soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    stack.func_190918_g(1);
                    holder.toItemStack(weaponStack);
                    return ActionResult.func_226249_b_((Object)stack);
                }
            }
        } else if (!weaponStack.func_190926_b() && this.isItemValidForApplication(weaponStack)) {
            AnointmentHolder holder = AnointmentHolder.fromItemStack(weaponStack);
            if (holder == null) {
                holder = new AnointmentHolder();
            }
            if (holder.canApplyAnointment(weaponStack, AnointmentRegistrar.ANOINTMENT_MAP.get(this.anointRL), new AnointmentData(this.level, 0, this.maxDamage))) {
                boolean flag1 = false;
                double d0 = (double)(this.colour >> 16 & 0xFF) / 255.0;
                double d1 = (double)(this.colour >> 8 & 0xFF) / 255.0;
                double d2 = (double)(this.colour >> 0 & 0xFF) / 255.0;
                for (int i = 0; i < 16; ++i) {
                    world.func_195594_a((IParticleData)(flag1 ? ParticleTypes.field_197608_a : ParticleTypes.field_197625_r), player.func_226282_d_(0.3), player.func_226279_cv_(), player.func_226287_g_(0.3), d0, d1, d2);
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean isItemValidForApplication(ItemStack stack) {
        return ItemAnointmentProvider.isItemTool(stack) || ItemAnointmentProvider.isItemSword(stack);
    }

    public static boolean isItemTool(ItemStack stack) {
        return !stack.func_77973_b().getToolTypes(stack).isEmpty();
    }

    public static boolean isItemSword(ItemStack stack) {
        return stack.func_77973_b() instanceof SwordItem;
    }

    public int getColor() {
        return this.colour;
    }
}

