/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;

public abstract class ItemSigilFluidBase
extends ItemSigilBase {
    public final FluidStack sigilFluid;

    public ItemSigilFluidBase(String name, int lpUsed, FluidStack fluid) {
        super(name, lpUsed);
        this.sigilFluid = fluid;
    }

    public ItemSigilFluidBase(String name, FluidStack fluid) {
        super(name);
        this.sigilFluid = fluid;
    }

    public ItemSigilFluidBase(String name) {
        super(name);
        this.sigilFluid = null;
    }

    @Nullable
    protected IFluidHandler getFluidHandler(World world, BlockPos blockPos, @Nullable Direction side) {
        BlockState state = world.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        IFluidHandler targetFluidHandler = (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)blockPos, (Direction)side).orElse(null);
        if (targetFluidHandler == null) {
            // empty if block
        }
        return targetFluidHandler;
    }

    protected boolean tryInsertSigilFluid(IFluidHandler destination, boolean doTransfer) {
        if (destination == null) {
            return false;
        }
        return destination.fill(this.sigilFluid, doTransfer ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    protected boolean tryRemoveFluid(IFluidHandler source, int amount, boolean doTransfer) {
        if (source == null) {
            return false;
        }
        return source.drain(amount, doTransfer ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE) != null;
    }

    protected boolean tryPlaceSigilFluid(PlayerEntity player, World world, BlockPos blockPos) {
        FluidStack resource = this.sigilFluid;
        BlockState state = this.sigilFluid.getFluid().getAttributes().getBlock((IBlockDisplayReader)world, blockPos, this.sigilFluid.getFluid().func_207188_f());
        BlockWrapper wrapper = new BlockWrapper(state, world, blockPos);
        if (world.func_230315_m_().func_236040_e_() && resource.getFluid().getAttributes().doesVaporize((IBlockDisplayReader)world, blockPos, resource)) {
            resource.getFluid().getAttributes().vaporize(player, world, blockPos, resource);
            return true;
        }
        return wrapper.fill(this.sigilFluid, IFluidHandler.FluidAction.EXECUTE) > 0;
    }
}

