/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class ARCRecipeSerializer<RECIPE extends RecipeARC>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ARCRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        JsonArray tool = JSONUtils.func_151202_d((JsonObject)json, (String)"tool") ? JSONUtils.func_151214_t((JsonObject)json, (String)"tool") : JSONUtils.func_152754_s((JsonObject)json, (String)"tool");
        Ingredient inputIng = Ingredient.func_199802_a((JsonElement)input);
        Ingredient toolIng = Ingredient.func_199802_a((JsonElement)tool);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        ArrayList<Pair<ItemStack, Double>> addedItems = new ArrayList<Pair<ItemStack, Double>>();
        if (json.has("addedoutput") && JSONUtils.func_151202_d((JsonObject)json, (String)"addedoutput")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"addedoutput");
            for (JsonElement element : mainArray) {
                if (addedItems.size() >= 3) break;
                if (!element.isJsonObject()) continue;
                JsonObject obj = element.getAsJsonObject();
                double chance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
                ItemStack extraDrop = SerializerHelper.getItemStack(obj, "type");
                addedItems.add((Pair<ItemStack, Double>)Pair.of((Object)extraDrop, (Object)chance));
            }
        }
        FluidStackIngredient inputFluidIng = null;
        if (json.has("inputfluid")) {
            JsonArray inputFluid = JSONUtils.func_151202_d((JsonObject)json, (String)"inputfluid") ? JSONUtils.func_151214_t((JsonObject)json, (String)"inputfluid") : JSONUtils.func_152754_s((JsonObject)json, (String)"inputfluid");
            inputFluidIng = FluidStackIngredient.deserialize((JsonElement)inputFluid);
        }
        FluidStack outputFluidStack = FluidStack.EMPTY;
        if (json.has("outputfluid")) {
            JsonObject outputFluid = JSONUtils.func_152754_s((JsonObject)json, (String)"outputfluid").getAsJsonObject();
            outputFluidStack = SerializerHelper.deserializeFluid(outputFluid);
        }
        boolean consumeIngredient = JSONUtils.func_151212_i((JsonObject)json, (String)"consumeingredient");
        return this.factory.create(recipeId, inputIng, toolIng, inputFluidIng, output, addedItems, outputFluidStack, consumeIngredient);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ArrayList<Pair<ItemStack, Double>> addedItems = new ArrayList<Pair<ItemStack, Double>>();
            Ingredient inputIng = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient toolIng = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            int addedItemSize = buffer.readInt();
            for (int i = 0; i < addedItemSize; ++i) {
                ItemStack stack = buffer.func_150791_c();
                double chance = buffer.readDouble();
                addedItems.add(Pair.of((Object)stack, (Object)chance));
            }
            FluidStackIngredient inputFluid = null;
            FluidStack outputFluid = new FluidStack(Fluids.field_204541_a, 1000);
            if (buffer.readBoolean()) {
                inputFluid = FluidStackIngredient.read(buffer);
            }
            if (buffer.readBoolean()) {
                outputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
            }
            boolean consumeIngredient = buffer.readBoolean();
            return this.factory.create(recipeId, inputIng, toolIng, inputFluid, output, addedItems, outputFluid, consumeIngredient);
        }
        catch (Exception e) {
            BloodMagic.LOGGER.error("Error reading ARC recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((RecipeARC)recipe).write(buffer);
        }
        catch (Exception e) {
            BloodMagic.LOGGER.error("Error writing ARC recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeARC> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, Ingredient var3, FluidStackIngredient var4, ItemStack var5, List<Pair<ItemStack, Double>> var6, FluidStack var7, boolean var8);
    }
}

