/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.render.alchemyarray.AlchemyArrayRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.BindingAlchemyCircleRenderer;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRegistry;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;

public class AlchemyArrayRendererRegistry {
    @OnlyIn(value=Dist.CLIENT)
    public static final AlchemyArrayRenderer DEFAULT_RENDERER = new AlchemyArrayRenderer(new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/basearray.png"));
    @OnlyIn(value=Dist.CLIENT)
    public static Map<ResourceLocation, AlchemyArrayRenderer> rendererMap = new HashMap<ResourceLocation, AlchemyArrayRenderer>();

    @OnlyIn(value=Dist.CLIENT)
    public static boolean registerRenderer(ResourceLocation rl, AlchemyArrayRenderer renderer) {
        boolean hadKey = rendererMap.containsKey(rl);
        rendererMap.put(rl, renderer);
        return hadKey;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static AlchemyArrayRenderer getRenderer(World world, ResourceLocation rl, RecipeAlchemyArray recipe) {
        if (rendererMap.containsKey(rl)) {
            return rendererMap.get(rl);
        }
        ResourceLocation texture = recipe.getTexture();
        if (AlchemyArrayRegistry.BINDING_ARRAY.equals((Object)texture)) {
            return new BindingAlchemyCircleRenderer();
        }
        if (texture != null) {
            return new AlchemyArrayRenderer(texture);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static AlchemyArrayRenderer getRenderer(World world, ItemStack input, ItemStack catalyst) {
        Pair<Boolean, RecipeAlchemyArray> array = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyArray(world, input, catalyst);
        if (array == null || array.getRight() == null) {
            return null;
        }
        return AlchemyArrayRendererRegistry.getRenderer(world, ((RecipeAlchemyArray)array.getRight()).func_199560_c(), (RecipeAlchemyArray)array.getRight());
    }
}

