/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wayoftime.bloodmagic.tile.base.TileBase;

public class TileInventory
extends TileBase
implements IInventory {
    protected int[] syncedSlots = new int[0];
    protected NonNullList<ItemStack> inventory;
    LazyOptional<IItemHandler> handlerDown;
    LazyOptional<IItemHandler> handlerUp;
    LazyOptional<IItemHandler> handlerNorth;
    LazyOptional<IItemHandler> handlerSouth;
    LazyOptional<IItemHandler> handlerWest;
    LazyOptional<IItemHandler> handlerEast;
    private int size;
    private String name;

    public TileInventory(TileEntityType<?> type, int size, String name) {
        super(type);
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.size = size;
        this.name = name;
        this.initializeItemHandlers();
    }

    protected boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deserialize(CompoundNBT tagCompound) {
        super.deserialize(tagCompound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tagCompound, this.inventory);
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tagCompound) {
        super.serialize(tagCompound);
        ItemStackHelper.func_191282_a((CompoundNBT)tagCompound, this.inventory);
        return tagCompound;
    }

    public void dropItems() {
        InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)this);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!this.func_70301_a(index).func_190926_b()) {
            if (!this.func_145831_w().field_72995_K) {
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
            if (this.func_70301_a(index).func_190916_E() <= count) {
                ItemStack itemStack = (ItemStack)this.inventory.get(index);
                this.inventory.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = ((ItemStack)this.inventory.get(index)).func_77979_a(count);
            this.func_70296_d();
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            ItemStack itemStack = (ItemStack)this.inventory.get(slot);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.inventory = NonNullList.func_191197_a((int)this.size, (Object)ItemStack.field_190927_a);
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    protected void initializeItemHandlers() {
        if (this instanceof ISidedInventory) {
            this.handlerDown = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.DOWN));
            this.handlerUp = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.UP));
            this.handlerNorth = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.NORTH));
            this.handlerSouth = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.SOUTH));
            this.handlerWest = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.WEST));
            this.handlerEast = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.EAST));
        } else {
            this.handlerDown = LazyOptional.of(() -> new InvWrapper((IInventory)this));
            this.handlerUp = this.handlerDown;
            this.handlerNorth = this.handlerDown;
            this.handlerSouth = this.handlerDown;
            this.handlerWest = this.handlerDown;
            this.handlerEast = this.handlerDown;
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    return this.handlerDown.cast();
                }
                case EAST: {
                    return this.handlerEast.cast();
                }
                case NORTH: {
                    return this.handlerNorth.cast();
                }
                case SOUTH: {
                    return this.handlerSouth.cast();
                }
                case UP: {
                    return this.handlerUp.cast();
                }
                case WEST: {
                    return this.handlerWest.cast();
                }
            }
        } else if (facing == null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlerDown.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.handlerDown != null) {
            this.handlerDown.invalidate();
        }
        if (this.handlerEast != null) {
            this.handlerEast.invalidate();
        }
        if (this.handlerNorth != null) {
            this.handlerNorth.invalidate();
        }
        if (this.handlerSouth != null) {
            this.handlerSouth.invalidate();
        }
        if (this.handlerUp != null) {
            this.handlerUp.invalidate();
        }
        if (this.handlerUp != null) {
            this.handlerUp.invalidate();
        }
    }
}

