/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.temp;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.darkhax.darkutils.temp.DUFakePlayer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="darkutils", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FakePlayerFactory {
    private static Map<GameProfile, FakePlayer> fakePlayers = Maps.newHashMap();

    public static FakePlayer get(ServerWorld world, GameProfile username) {
        if (!fakePlayers.containsKey(username)) {
            DUFakePlayer fakePlayer = new DUFakePlayer(world, username);
            fakePlayers.put(username, fakePlayer);
        }
        return fakePlayers.get(username);
    }

    public static void unloadWorld(ServerWorld world) {
        fakePlayers.entrySet().removeIf(entry -> ((FakePlayer)entry.getValue()).field_70170_p == world);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDimensionUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            FakePlayerFactory.unloadWorld((ServerWorld)event.getWorld());
        }
    }
}

