/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DrawerInventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropInventoryItems(World world, BlockPos pos, IDrawerGroup group) {
        block0: for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            while (drawer.getStoredItemCount() > 0) {
                ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
                int storedCount = drawer.getStoredItemCount();
                int stackLimit = stack.func_77976_d();
                int stackSize = Math.min(storedCount, stackLimit);
                stack.func_190920_e(stackSize);
                if (stack.func_190926_b()) continue block0;
                DrawerInventoryHelper.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
                drawer.adjustStoredItemCount(-stackSize);
            }
        }
    }

    private static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        float xOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float yOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float zOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            ItemEntity entityitem = new ItemEntity(world, x + (double)xOff, y + (double)yOff, z + (double)zOff, stack.func_77979_a(RANDOM.nextInt(21) + 10));
            float velocity = 0.05f;
            entityitem.func_213293_j(RANDOM.nextGaussian() * (double)velocity, RANDOM.nextGaussian() * (double)velocity + (double)0.2f, RANDOM.nextGaussian() * (double)velocity);
            world.func_217376_c((Entity)entityitem);
        }
    }
}

